; NsPack v2.9-3.4(3.x(?)) (tested with v2.9,v3.0,v3.1,v3.3,v3.4) module for HzorInline v1.x by arnix
; Module engine: v3
; Please read readme.txt file of the program for more information
; Copyright (C) arnix, 2005-2006
; E-mail: arnix@freenet.am

format PE GUI 4.0 DLL
entry DllEntryPoint

include '%fasminc%/win32a.inc'

section '.i' import data readable writeable

   library kernel32,	'KERNEL32.DLL',\
	   user32,	'USER32.DLL'

	   include	'%fasminc%/apia/kernel32.inc'
	   include	'%fasminc%/apia/user32.inc'


section '.d' data readable writeable

wMZ		    dw 'MZ'
dwPE		    dd 00004550h
dwSectNumber	    dw 0
dwImageBase	    dd 0
dwFileAlignment     dd 0
dwSectionsAddr	    dd 0
dwVOffset	    dd 0
dwRSize 	    dd 0
dwVSize 	    dd 0
dwROffset	    dd 0
dwFREEVABuffer	    dd 0

dwFileName	    dd 0
dwFile		    dd 0
dwFileSize	    dd 0
dwIdScript	    dd 0
dwMemptr	    dd 0
dwRead		    dd 0

NsPackSig	    db 5Ah,5Bh,59h,5Eh,83h,0C3h,0Ch,0E2h,0E1h,0B8h,00h,00h,00h,00h,83h,0F8h,00h,74h,0Ah,61h,9Dh,0B8h,01h,00h,00h,00h,0C2h,0Ch,00h,61h,9Dh,0E9h
NsPackSigSize	    dd $-NsPackSig

NsPackSig2	    db 80h,0F9h,00h,74h,28h
NsPackSigSize2	    dd $-NsPackSig2

szAboutCap	    db 'About',0
szAboutMes	    db 'NsPack v2.9/3.4 (3.x(?)) module (tested with v2.9,v3.0,v3.1,v3.3,v3.4)',13,10,\
		       'Designed for use with [HzorInline v1.x by arnix]',13,10,'Module engine: v3',13,10,'Coded by arnix',13,10,'Source is available',13,10,\
		       'E-mail: arnix@freenet.am',13,10,'URL: http://arnix.at.googlepages.com',0
szModuleName	    db 'NsPack 2.9-3.4(3.x(?)) -> North Star',0
dwModuleNameSz	    dd $-szModuleName
szErrorCap	    db 'Error',0
szMainProcComm	    db ';MAIN PROCEDURE START',13,10
dwMainProcCommSz    dd $-szMainProcComm
szProc		    db 'PROC',13,10
dwProcSz	    dd $-szProc
szEndp		    db 'ENDP',13,10
dwEndpSz	    dd $-szEndp
szMainProcEndComm   db ';MAIN PROCEDURE END',13,10
dwMainProcEndCommSz dd $-szMainProcEndComm
szNop		    db 'NOP',13,10
dwNopSz 	    dd $-szNop
szPushad	    db 'PUSHAD',13,10
dwPushadSz	    dd $-szPushad
szAddHereYrPatch    db ';ADD HERE YOUR PATCH STRINGS',13,10
dwAddHereYrPatchSz  dd $-szAddHereYrPatch
szRest		    db 'REST',13,10
dwRestSz	    dd $-szRest
szPushOEP	    db 'PUSH OEP',13,10
dwPushOEPSz	    dd $-szPushOEP
szPushOUT	    db 'PUSH OUT',13,10
dwPushOUTSz	    dd $-szPushOUT
szRetn		    db 'RETN',13,10
dwRetnSz	    dd $-szRetn
szPopad 	    db 'POPAD',13,10
dwPopadSz	    dd $-szPopad
szNewLine	    db 13,10
dwNewLineSz	    dd $-szNewLine
szOUT		    db 'OUT='
dwOUTSz 	    dd $-szOUT
szOEP		    db 'OEP='
dwOEPSz 	    dd $-szOEP
szFREE		    db 'FREE='
dwFREESz	    dd $-szFREE
szFREEAUTO	    db 'FREE=AUTO'
dwFREEAUTOSz	    dd $-szFREEAUTO
szFREEAPPEND	    db 'FREE=APPEND'
dwFREEAPPENDSz	    dd $-szFREEAPPEND
szOUTCODE	    db 'OUT_CODE='
dwOUTCODESz	    dd $-szOUTCODE
szFileOpenError     db 'NSPACK_29_34.DLL Module: Can not open file!',0
szAllocError	    db 'NSPACK_29_34.DLL Module: Can not allocate memory!',0
szInvalidPEError    db 'NSPACK_29_34.DLL Module: The file is not a valid win32 PE file!',0
szCantFindAddrError db 'NSPACK_29_34.DLL Module: Can not find the address! Maybe the file is not packed with NsPack v1.x-2.x?',0
szUnknownError	    db 'NSPACK_29_34.DLL Module: Unknown error!',0

szBuffer	    rb 800h
szOEPBuffer	    rb 0Ch
szOUTBuffer	    rb 0Ch
szFREEBuffer	    rb 0Ch
szMAXSIZEBuffer     rb 0Ch
szPATCHBuffer	    rb 0Ch
szPATCHBuffer2	    rb 0Ch

section '.c' code readable executable

proc DllEntryPoint, hinstDLL,fdwReason,lpvReserved
   or	   eax,-1
   ret
endp

proc HzorInit ;Here we get the address of the string with filename of packed exe in EAX register
   mov	  [dwFileName],eax
   ;We can do here some other initializations if we need.. Return 0 in EAX if any error occures.
   or eax,-1
   retn
endp

proc HzorDoJob ;Here we get the handle of script window in EAX register
   mov	  [dwIdScript],eax
  ;=============================================================================
  ;If we want we can add there any lines, e.g. for patching CRC check of a packer
  ;szString db 'P,004050AB,EB',13,10,'P,004050BB,90',0
  ;...
  ;invoke  SendMessage,[dwIdScript],WM_SETTEXT,NULL,szString
  ;=============================================================================
   invoke SetFileAttributes,[dwFileName],0080h
   invoke CreateFile,[dwFileName],80000000h,0,0,3,0080h,0
   mov	  [dwFile],eax
   cmp	  eax,-1
   jnz	  @f
   invoke MessageBox,NULL,szFileOpenError,szErrorCap,MB_OK
   xor	  eax,eax
   retn
@@:
   invoke GetFileSize,[dwFile],0
   mov	  [dwFileSize],eax
   invoke GlobalAlloc,0000h,[dwFileSize]
   mov	  [dwMemptr],eax
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szAllocError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  _exit
@@:
   invoke ReadFile,[dwFile],[dwMemptr],[dwFileSize],dwRead,0
   invoke CloseHandle,[dwFile]
   mov	  edi,[dwMemptr]
   mov	  esi,edi
   add	  esi,[dwFileSize]
   dec	  esi
   mov	  ax,word [edi]
   cmp	  ax,[wMZ]
   jz	  @f
   invoke MessageBox,NULL,szInvalidPEError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  _exit
@@:
   add	  edi,3Ch
   mov	  eax,[edi]
   mov	  edi,[dwMemptr]
   add	  edi,eax
   mov	  eax,[edi]
   cmp	  eax,[dwPE]
   jz	  @f
   invoke MessageBox,NULL,szInvalidPEError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  _exit
@@:
   push   edi
   add	  edi,06h
   mov	  ax,word [edi]
   mov	  [dwSectNumber],ax
   add	  edi,2Eh
   push   dword [edi]
   pop	  [dwImageBase]
   pop	  edi
   push   edi
   add	  edi,03Ch
   push   dword [edi]
   pop	  [dwFileAlignment]
   pop	  edi
   mov	  eax,edi
   add	  eax,14h
   movzx  eax,word [eax]
   add	  eax,18h ;Size of PE Header
   mov	  [dwSectionsAddr],edi
   add	  [dwSectionsAddr],eax
   add	  edi,28h
   mov	  edi,[edi] ;Entry point RVA
   mov	  eax,edi
   call   rva2raw
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szUnknownError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  _exit
@@:
   mov	  edi,eax
   add	  edi,[dwMemptr]
   mov	  esi,[dwMemptr]
   add	  esi,[dwFileSize]
   dec	  esi
   cmp	  byte [edi],0E9h
   jnz	  _isnot0E9
   inc	  edi
   push   dword [edi]
   sub	  edi,[dwMemptr]
   mov	  eax,edi
   call   raw2va
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szUnknownError,szErrorCap,MB_OK
   xor	  eax,eax
   pop	  edi
   jmp	  _exit
@@:
   pop	  edi
   add	  edi,eax
   add	  edi,5
   mov	  eax,edi
   sub	  eax,[dwImageBase]
   call   rva2raw
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szUnknownError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  _exit
@@:
   mov	  edi,eax
   add	  edi,[dwMemptr]
_isnot0E9:
   mov	  al,5Ah ;pop edx opcode
@@:
   inc	  edi
   cmp	  byte [edi],al
   jz	  .found_popedx
.continue_search:
   cmp	  edi,esi
   jb	  @b
;not found
   invoke MessageBox,NULL,szCantFindAddrError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  _exit

.found_popedx:
   push   esi
   push   edi
   mov	  esi,NsPackSig
   mov	  ecx,[NsPackSigSize]
   repz   cmpsb
   test   ecx,ecx
   jz	  @f
   pop	  edi
   pop	  esi
   jmp	  .continue_search
@@:
   pop	  edi
   pop	  esi

;found
   add	  edi,20h
   mov	  eax,edi
   mov	  edi,dword [edi]
   sub	  eax,[dwMemptr]
   push   eax

   mov	  eax,[dwFileSize]
   call   raw2va
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szUnknownError,szErrorCap,MB_OK
   pop	  eax
   xor	  eax,eax
   jmp	  _exit
@@:
   mov	  [dwFREEVABuffer],eax
   pop	  eax
   push   eax
   call   raw2va
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szUnknownError,szErrorCap,MB_OK
   pop	  eax
   xor	  eax,eax
   jmp	  _exit
@@:
   sub	  [dwFREEVABuffer],eax
   sub	  [dwFREEVABuffer],4

   pop	  eax
   push   edi
   push   eax
   mov	  edi,szOUTBuffer
   call   raw2va
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szUnknownError,szErrorCap,MB_OK
   pop	  eax
   pop	  edi
   xor	  eax,eax
   jmp	  _exit
@@:
   call   dword2hex
   pop	  eax
   pop	  edi
   call   raw2va
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szUnknownError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  _exit
@@:
   add	  eax,edi
   add	  eax,4
   mov	  edi,szOEPBuffer
   call   dword2hex

   mov	  edi,[dwMemptr]
   mov	  esi,edi
   add	  esi,[dwFileSize]
   dec	  esi
   mov	  al,80h
@@:
   inc	  edi
   cmp	  byte [edi],al
   jz	  .found_it
.continue_search2:
   cmp	  edi,esi
   jb	  @b
;not found
   invoke MessageBox,NULL,szCantFindAddrError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  _exit

.found_it:
   push   esi
   push   edi
   mov	  esi,NsPackSig2
   mov	  ecx,[NsPackSigSize2]
   inc	  ecx
   repz   cmpsb
   test   ecx,ecx
   jz	  @f
   pop	  edi
   pop	  esi
   jmp	  .continue_search2
@@:
   pop	  edi
   pop	  esi

;found
   add	  edi,3
   sub	  edi,[dwMemptr]
   mov	  eax,edi
   mov	  edi,szPATCHBuffer2
   call   raw2va
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szUnknownError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  _exit
@@:
   call   dword2hex

   mov	  edi,szBuffer

   mov	  esi,szOEP
   mov	  ecx,[dwOEPSz]
   rep	  movsb

   mov	  esi,szOEPBuffer
   call   str_len
   mov	  ecx,eax
   rep	  movsb

   mov	  esi,szNewLine
   mov	  ecx,[dwNewLineSz]
   rep	  movsb

   mov	  esi,szFREEAPPEND
   mov	  ecx,[dwFREEAPPENDSz]
   rep	  movsb

   mov	  esi,szNewLine
   mov	  ecx,[dwNewLineSz]
   rep	  movsb

   mov	  al,'P'
   stosb
   mov	  al,','
   stosb
   mov	  esi,szPATCHBuffer2
   call   str_len
   dec	  eax
@@:
   inc	  eax
   cmp	  eax,8
   jz	  @f
   mov	  byte [edi],'0'
   inc	  edi
   jmp	  @b
@@:
   mov	  esi,szPATCHBuffer2
   call   str_len
   mov	  ecx,eax
   rep	  movsb

   mov	  al,','
   stosb

   mov	  eax,000000EBh
   call   dword2hex
   add	  edi,2

   mov	  esi,szNewLine
   mov	  ecx,[dwNewLineSz]
   rep	  movsb

   mov	  esi,szOUT
   mov	  ecx,[dwOUTSz]
   rep	  movsb

   mov	  esi,szOUTBuffer
   call   str_len
   dec	  eax
@@:
   inc	  eax
   cmp	  eax,8
   jz	  @f
   mov	  byte [edi],'0'
   inc	  edi
   jmp	  @b
@@:
   mov	  esi,szOUTBuffer
   call   str_len
   mov	  ecx,eax
   rep	  movsb

   mov	  esi,szNewLine
   mov	  ecx,[dwNewLineSz]
   rep	  movsb

   mov	  esi,szOUTCODE
   mov	  ecx,[dwOUTCODESz]
   rep	  movsb

   mov	  al,'#'
   stosb

   mov	  esi,dwFREEVABuffer
   mov	  ecx,5
   dec	  esi
_next:
   inc	  esi
   dec	  ecx
   jz	  _finish
   xor	  eax,eax
   mov	  al,byte [esi]
   cmp	  eax,0Fh
   ja	  @f
   push   eax
   mov	  al,'0'
   stosb
   pop	  eax
@@:
   call   dword2hex
   dec	  edi
@@:
   inc	  edi
   cmp	  byte [edi],0
   jnz	  @b
   jmp	  _next

_finish:

   mov	  al,'#'
   stosb

   mov	  esi,szNewLine
   mov	  ecx,[dwNewLineSz]
   rep	  movsb

   mov	  esi,szMainProcComm
   mov	  ecx,[dwMainProcCommSz]
   rep	  movsb

   mov	  esi,szProc
   mov	  ecx,[dwProcSz]
   rep	  movsb

   mov	  esi,szNop
   mov	  ecx,[dwNopSz]
   rep	  movsb

   mov	  esi,szPushad
   mov	  ecx,[dwPushadSz]
   rep	  movsb

   mov	  esi,szNewLine
   mov	  ecx,[dwNewLineSz]
   rep	  movsb

   mov	  esi,szAddHereYrPatch
   mov	  ecx,[dwAddHereYrPatchSz]
   rep	  movsb

   mov	  esi,szNewLine
   mov	  ecx,[dwNewLineSz]
   rep	  movsb

   mov	  esi,szPopad
   mov	  ecx,[dwPopadSz]
   rep	  movsb

   mov	  esi,szPushOEP
   mov	  ecx,[dwPushOEPSz]
   rep	  movsb

   mov	  esi,szRetn
   mov	  ecx,[dwRetnSz]
   rep	  movsb

   mov	  esi,szEndp
   mov	  ecx,[dwEndpSz]
   rep	  movsb

   mov	  esi,szMainProcEndComm
   mov	  ecx,[dwMainProcEndCommSz]
   rep	  movsb

   mov	  al,0
   stosb

   invoke  SendMessage,[dwIdScript],WM_SETTEXT,NULL,szBuffer
   or	   eax,-1 ; mov eax,-1
_exit:
   push   eax
   invoke GlobalFree, [dwMemptr]
   pop	  eax
   retn
endp

proc HzorPluginInfo
   invoke MessageBox,NULL,szAboutMes,szAboutCap,MB_OK
   retn
endp

proc HzorIdentify
   invoke SetFileAttributes,[dwFileName],0080h
   invoke CreateFile,[dwFileName],80000000h,0,0,3,0080h,0
   mov	  [dwFile],eax
   cmp	  eax,-1
   jnz	  @f
   xor	  eax,eax
   retn
@@:
   invoke GetFileSize,[dwFile],0
   mov	  [dwFileSize],eax
   invoke GlobalAlloc,0000h,[dwFileSize]
   mov	  [dwMemptr],eax
   test   eax,eax
   jnz	  @f
   xor	  eax,eax
   jmp	  _ret
@@:
   invoke ReadFile,[dwFile],[dwMemptr],[dwFileSize],dwRead,0
   invoke CloseHandle,[dwFile]
   mov	  edi,[dwMemptr]
   mov	  esi,edi
   add	  esi,[dwFileSize]
   dec	  esi
   mov	  ax,word [edi]
   cmp	  ax,[wMZ]
   jz	  @f
   xor	  eax,eax
   jmp	  _ret
@@:
   add	  edi,3Ch
   mov	  eax,[edi]
   mov	  edi,[dwMemptr]
   add	  edi,eax
   mov	  eax,[edi]
   cmp	  eax,[dwPE]
   jz	  @f
   xor	  eax,eax
   jmp	  _ret
@@:
   push   edi
   add	  edi,06h
   mov	  ax,word [edi]
   mov	  [dwSectNumber],ax
   add	  edi,2Eh
   push   dword [edi]
   pop	  [dwImageBase]
   pop	  edi
   push   edi
   add	  edi,03Ch
   push   dword [edi]
   pop	  [dwFileAlignment]
   pop	  edi
   mov	  eax,edi
   add	  eax,14h
   movzx  eax,word [eax]
   add	  eax,18h ;Size of PE Header
   mov	  [dwSectionsAddr],edi
   add	  [dwSectionsAddr],eax
   add	  edi,28h
   mov	  edi,[edi] ;Entry point RVA
   push   edi

   mov	  edi,[dwMemptr]
   mov	  esi,edi
   add	  esi,[dwFileSize]
   dec	  esi
   mov	  al,80h
@@:
   inc	  edi
   cmp	  byte [edi],al
   jz	  .found_it2
.continue_search4:
   cmp	  edi,esi
   jb	  @b
;not found
   pop	  edi
   xor	  eax,eax
   jmp	  _ret

.found_it2:
   push   esi
   push   edi
   mov	  esi,NsPackSig2
   mov	  ecx,[NsPackSigSize2]
   inc	  ecx
   repz   cmpsb
   test   ecx,ecx
   jz	  @f
   pop	  edi
   pop	  esi
   jmp	  .continue_search4
@@:
   pop	  edi
   pop	  esi
;found

   pop	  edi
   mov	  eax,edi
   call   rva2raw
   test   eax,eax
   jnz	  @f
   xor	  eax,eax
   jmp	  _ret
@@:
   mov	  edi,eax
   add	  edi,[dwMemptr]
   mov	  esi,[dwMemptr]
   add	  esi,[dwFileSize]
   dec	  esi
   cmp	  byte [edi],0E9h
   jnz	  @f
   inc	  edi
   push   dword [edi]
   sub	  edi,[dwMemptr]
   mov	  eax,edi
   call   raw2va
   test   eax,eax
   jnz	  _f1
   pop	  eax
   xor	  eax,eax
   jmp	  _ret
_f1:
   pop	  edi
   add	  edi,eax
   add	  edi,5
   mov	  eax,edi
   sub	  eax,[dwImageBase]
   call   rva2raw
   test   eax,eax
   jnz	  _f2
   xor	  eax,eax
   jmp	  _exit
_f2:
   mov	  edi,eax
   add	  edi,[dwMemptr]
@@:
   mov	  al,5Ah ;pop edx opcode
@@:
   inc	  edi
   cmp	  byte [edi],al
   jz	  .found_popedx3
.continue_search3:
   cmp	  edi,esi
   jb	  @b
;not found
   xor	  eax,eax
   jmp	  _ret
.found_popedx3:
   push   esi
   push   edi
   mov	  esi,NsPackSig
   mov	  ecx,[NsPackSigSize]
   repz   cmpsb
   test   ecx,ecx
   jz	  @f
   pop	  edi
   pop	  esi
   jmp	  .continue_search3
@@:
   pop	  edi
   pop	  esi

;found
   or	  eax,-1
_ret:
   retn
endp

; =========================================================================================
; (C) arnix [arnix@freenet.am]
proc raw2va
   push   esi
   push   edi
   push   ecx

   xor	  ecx,ecx
   mov	  cx,[dwSectNumber]
   mov	  edi,[dwSectionsAddr]
.next_section:
   push   eax

   push   dword [edi+0Ch]
   pop	  [dwVOffset]

   push   dword [edi+10h]
   pop	  eax
   xor	  edx,edx
   div	  [dwFileAlignment]
   mul	  [dwFileAlignment]
   add	  eax,[dwFileAlignment]
   mov	  [dwRSize],eax

   push   dword [edi+14h]
   pop	  eax
   xor	  edx,edx
   div	  [dwFileAlignment]
   mul	  [dwFileAlignment]
   mov	  [dwROffset],eax

   pop	  eax

   cmp	  eax,[dwROffset]
   jna	  @f
   mov	  esi,[dwRSize]
   add	  esi,[dwROffset]
   cmp	  eax,esi
   ja	  @f
   mov	  esi,[dwVOffset]
   add	  esi,eax
   mov	  eax,esi
   add	  eax,[dwImageBase]
   sub	  eax,[dwROffset]
   jmp	  .exit
@@:
   add	  edi,28h
   dec	  ecx
   jnz	  .next_section
;cant calculate
   xor	  eax,eax
.exit:
   pop	  ecx
   pop	  edi
   pop	  esi
retn
endp


; =========================================================================================
; (C) arnix [arnix@freenet.am]
proc rva2raw
   push   esi
   push   edi
   push   ecx

   xor	  ecx,ecx
   mov	  cx,[dwSectNumber]
   mov	  edi,[dwSectionsAddr]
.next_section:
   push   eax
   push   dword [edi+08h]
   pop	  [dwVSize]
   push   dword [edi+0Ch]
   pop	  [dwVOffset]
   push   dword [edi+14h]
   pop	  eax
   xor	  edx,edx
   div	  [dwFileAlignment]
   mul	  [dwFileAlignment]
   mov	  [dwROffset],eax
   pop	  eax

   cmp	  eax,[dwVOffset]
   jl	  @f
   mov	  esi,[dwVSize]
   add	  esi,[dwVOffset]
   cmp	  eax,esi
   jge	  @f
   sub	  eax,[dwVOffset]
   mov	  esi,[dwROffset]
   add	  esi,eax
   mov	  eax,esi
   jmp	  .exit

@@:
   add	  edi,28h
   dec	  ecx
   jnz	  .next_section
;cant calculate
   xor	  eax,eax
.exit:
   pop	  ecx
   pop	  edi
   pop	  esi
retn
endp


; =========================================================================================
; (C) arnix [arnix@freenet.am]
; Gets the dword value in EAX register and an address to a buffer to write the string in EDI (need max. 9 byte-length)
; Returns nothing, but the result is the zero-terminated string in address of EDI
proc dword2hex
   push    eax
   push    ecx
   push    edi

   push    10h
   pop	   ecx
   push    -30h
@@:
   xor	   edx,edx
   div	   ecx
   push    edx
   test    eax,eax
   jnz	   @b
.next:
   pop	   eax
   add	   al,30h
   cmp	   al,3Ah
   jb	   @f
   add	   al,07h
@@:
   stosb
   test    al,al
   jnz	   .next

   pop	   edi
   pop	   ecx
   pop	   eax
ret
endp

; =========================================================================================
; (C) arnix [arnix@freenet.am]
; Gets the address of zero terminated string in ESI register
; Returns the length in EAX register
proc str_len
   push    esi
   push    ecx

   or	   ecx,-1
@@:
   inc	   ecx
   lodsb
   test    al,al
   jnz	   @b

   push    ecx
   pop	   eax
   pop	   ecx
   pop	   esi
retn
endp

section '.e' export data readable

  export 'NSPACK_29_34.DLL',\
	 HzorInit,'HzorInit',\
	 HzorDoJob,'HzorDoJob',\
	 HzorPluginInfo,'HzorPluginInfo',\
	 HzorIdentify,'HzorIdentify'

section '.r' fixups data discardable