/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2;

import com.google.common.collect.Maps;
import java.util.HashMap;
import org.jf.util.ExceptionWithContext;

public class VerificationError {
    private static final HashMap<String, Integer> verificationErrorNames = Maps.newHashMap();

    public static int getVerificationError(String verificationError) {
        Integer ret = verificationErrorNames.get(verificationError);
        if (ret == null) {
            throw new ExceptionWithContext("Invalid verification error: %s", verificationError);
        }
        return ret;
    }

    public static boolean isValidVerificationError(int verificationError) {
        return verificationError > 0 && verificationError < 10;
    }

    static {
        verificationErrorNames.put("generic-error", 1);
        verificationErrorNames.put("no-such-class", 2);
        verificationErrorNames.put("no-such-field", 3);
        verificationErrorNames.put("no-such-method", 4);
        verificationErrorNames.put("illegal-class-access", 5);
        verificationErrorNames.put("illegal-field-access", 6);
        verificationErrorNames.put("illegal-method-access", 7);
        verificationErrorNames.put("class-change-error", 8);
        verificationErrorNames.put("instantiation-error", 9);
    }
}

