/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

public class BitSet
implements Cloneable {
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] bits_) {
        this.bits = bits_;
    }

    public BitSet(int nbits) {
        this.bits = new long[(nbits - 1 >> 6) + 1];
    }

    public BitSet or(BitSet a) {
        if (a == null) {
            return this;
        }
        BitSet s = (BitSet)this.clone();
        s.orInPlace(a);
        return s;
    }

    public void orInPlace(BitSet a) {
        if (a == null) {
            return;
        }
        if (a.bits.length > this.bits.length) {
            this.setSize(a.bits.length);
        }
        int min = Math.min(this.bits.length, a.bits.length);
        for (int i = min - 1; i >= 0; --i) {
            int n = i;
            this.bits[n] = this.bits[n] | a.bits[i];
        }
    }

    private void setSize(int nwords) {
        long[] newbits = new long[nwords];
        int n = Math.min(nwords, this.bits.length);
        System.arraycopy(this.bits, 0, newbits, 0, n);
        this.bits = newbits;
    }

    private static final long bitMask(int bitNumber) {
        int bitPosition = bitNumber & 0x3F;
        return 1L << bitPosition;
    }

    public Object clone() {
        BitSet s;
        try {
            s = (BitSet)super.clone();
            s.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, s.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return s;
    }

    public boolean equals(Object other) {
        block5: {
            int i;
            int n;
            BitSet otherSet;
            block4: {
                if (other == null || !(other instanceof BitSet)) {
                    return false;
                }
                otherSet = (BitSet)other;
                n = Math.min(this.bits.length, otherSet.bits.length);
                for (i = 0; i < n; ++i) {
                    if (this.bits[i] == otherSet.bits[i]) continue;
                    return false;
                }
                if (this.bits.length <= n) break block4;
                for (i = n + 1; i < this.bits.length; ++i) {
                    if (this.bits[i] == 0L) continue;
                    return false;
                }
                break block5;
            }
            if (otherSet.bits.length <= n) break block5;
            for (i = n + 1; i < otherSet.bits.length; ++i) {
                if (otherSet.bits[i] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean member(int el) {
        if (el < 0) {
            return false;
        }
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            return false;
        }
        return (this.bits[n] & BitSet.bitMask(el)) != 0L;
    }

    public void remove(int el) {
        int n = BitSet.wordNumber(el);
        if (n < this.bits.length) {
            int n2 = n;
            this.bits[n2] = this.bits[n2] & (BitSet.bitMask(el) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    private static final int wordNumber(int bit) {
        return bit >> 6;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String[] tokenNames) {
        StringBuilder buf = new StringBuilder();
        String separator = ",";
        boolean havePrintedAnElement = false;
        buf.append('{');
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            if (i > 0 && havePrintedAnElement) {
                buf.append(separator);
            }
            if (tokenNames != null) {
                buf.append(tokenNames[i]);
            } else {
                buf.append(i);
            }
            havePrintedAnElement = true;
        }
        buf.append('}');
        return buf.toString();
    }
}

