/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import org.jf.dexlib2.VersionMap;

public class HeaderItem {
    private static final byte[] MAGIC_VALUE = new byte[]{100, 101, 120, 10, 0, 0, 0, 0};

    public static byte[] getMagicForApi(int api) {
        return HeaderItem.getMagicForDexVersion(VersionMap.mapApiToDexVersion(api));
    }

    public static byte[] getMagicForDexVersion(int dexVersion) {
        byte[] magic = (byte[])MAGIC_VALUE.clone();
        if (dexVersion < 0 || dexVersion > 999) {
            throw new IllegalArgumentException("dexVersion must be within [0, 999]");
        }
        for (int i = 6; i >= 4; --i) {
            int digit = dexVersion % 10;
            magic[i] = (byte)(48 + digit);
            dexVersion /= 10;
        }
        return magic;
    }
}

