/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable.reference;

import org.jf.dexlib2.base.reference.BaseMethodHandleReference;
import org.jf.dexlib2.base.reference.BaseReference;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodHandleReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.immutable.reference.ImmutableFieldReference;
import org.jf.dexlib2.immutable.reference.ImmutableMethodReference;
import org.jf.dexlib2.immutable.reference.ImmutableReference;
import org.jf.util.ExceptionWithContext;

public class ImmutableMethodHandleReference
extends BaseMethodHandleReference
implements ImmutableReference {
    protected final int methodHandleType;
    protected final ImmutableReference memberReference;

    public ImmutableMethodHandleReference(int methodHandleType, ImmutableReference memberReference) {
        this.methodHandleType = methodHandleType;
        this.memberReference = memberReference;
    }

    public static ImmutableMethodHandleReference of(MethodHandleReference methodHandleReference) {
        BaseReference memberReference;
        if (methodHandleReference instanceof ImmutableMethodHandleReference) {
            return (ImmutableMethodHandleReference)methodHandleReference;
        }
        int methodHandleType = methodHandleReference.getMethodHandleType();
        switch (methodHandleType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                memberReference = ImmutableFieldReference.of((FieldReference)methodHandleReference.getMemberReference());
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                memberReference = ImmutableMethodReference.of((MethodReference)methodHandleReference.getMemberReference());
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid method handle type: %d", methodHandleType);
            }
        }
        return new ImmutableMethodHandleReference(methodHandleType, (ImmutableReference)((Object)memberReference));
    }

    @Override
    public int getMethodHandleType() {
        return this.methodHandleType;
    }

    @Override
    public Reference getMemberReference() {
        return this.memberReference;
    }
}

