/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class CollectionUtils {
    public static <T> int lastIndexOf(Iterable<T> iterable, Predicate<? super T> predicate) {
        int index = 0;
        int lastMatchingIndex = -1;
        for (T item : iterable) {
            if (predicate.apply(item)) {
                lastMatchingIndex = index;
            }
            ++index;
        }
        return lastMatchingIndex;
    }

    public static <T extends Comparable<? super T>> int compareAsList(Collection<? extends T> list1, Collection<? extends T> list2) {
        int res = Ints.compare(list1.size(), list2.size());
        if (res != 0) {
            return res;
        }
        Iterator<T> elements2 = list2.iterator();
        for (Comparable element1 : list1) {
            res = element1.compareTo(elements2.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static <T> int compareAsIterable(Comparator<? super T> comparator, Iterable<? extends T> it1, Iterable<? extends T> it2) {
        Iterator<T> elements2 = it2.iterator();
        for (T element1 : it1) {
            T element2;
            try {
                element2 = elements2.next();
            }
            catch (NoSuchElementException ex) {
                return 1;
            }
            int res = comparator.compare(element1, element2);
            if (res == 0) continue;
            return res;
        }
        if (elements2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static <T> boolean isNaturalSortedSet(Iterable<? extends T> it) {
        if (it instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)it;
            Comparator comparator = sortedSet.comparator();
            return comparator == null || comparator.equals(Ordering.natural());
        }
        return false;
    }

    private static <T> SortedSet<? extends T> toNaturalSortedSet(Collection<? extends T> collection) {
        if (CollectionUtils.isNaturalSortedSet(collection)) {
            return (SortedSet)collection;
        }
        return ImmutableSortedSet.copyOf(collection);
    }

    public static <T extends Comparable<T>> int compareAsSet(Collection<? extends T> set1, Collection<? extends T> set2) {
        int res = Ints.compare(set1.size(), set2.size());
        if (res != 0) {
            return res;
        }
        SortedSet<? extends T> sortedSet1 = CollectionUtils.toNaturalSortedSet(set1);
        SortedSet<? extends T> sortedSet2 = CollectionUtils.toNaturalSortedSet(set2);
        Iterator<T> elements2 = set2.iterator();
        for (Comparable element1 : set1) {
            res = element1.compareTo((Comparable)elements2.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }
}

