; eXPressor module (tested with 1.2.0.1, 1.3.0.1, 1.4.5.1) for HzorInline v1.x by arnix
; Module engine: v3
; Please read readme.txt file of the program for more information
; Copyright (C) arnix, 2005-2006
; E-mail: arnix@freenet.am

format PE GUI 4.0 DLL
entry DllEntryPoint

include '%fasminc%/win32a.inc'

section '.i' import data readable writeable

   library kernel32,	'KERNEL32.DLL',\
	   user32,	'USER32.DLL'

	   include	'%fasminc%/apia/kernel32.inc'
	   include	'%fasminc%/apia/user32.inc'


section '.d' data readable writeable

wMZ		    dw 'MZ'
dwPE		    dd 00004550h
dwSectNumber	    dw 0
dwImageBase	    dd 0
dwFileAlignment     dd 0
dwSectionsAddr	    dd 0
dwVOffset	    dd 0
dwRSize 	    dd 0
dwVSize 	    dd 0
dwROffset	    dd 0

dwFileName	    dd 0
dwFile		    dd 0
dwFileSize	    dd 0
dwIdScript	    dd 0
dwMemptr	    dd 0
dwRead		    dd 0

dwRipBytesAddr	    dd 0
dwRipBytesAddrSz    dd 0

szAboutCap	    db 'About',0
szAboutMes	    db 'eXPressor module (tested with 1.2.0.1, 1.3.0.1, 1.4.5.1)',13,10,\
		       'Designed for use with [HzorInlinev1.x by arnix]',13,10,'Module engine: v3',13,10,'Coded by arnix',13,10,'Source is available',13,10,\
		       'E-mail: arnix@freenet.am',13,10,'URL: http://arnix.at.googlepages.com',0
szModuleName	    db 'eXPressor -> CGSoftLabs',0
dwModuleNameSz	    dd $-szModuleName
szErrorCap	    db 'Error',0
szMainProcComm	    db ';MAIN PROCEDURE START',13,10
dwMainProcCommSz    dd $-szMainProcComm
szProc		    db 'PROC',13,10
dwProcSz	    dd $-szProc
szEndp		    db 'ENDP',13,10
dwEndpSz	    dd $-szEndp
szMainProcEndComm   db ';MAIN PROCEDURE END',13,10
dwMainProcEndCommSz dd $-szMainProcEndComm
szNop		    db 'NOP',13,10
dwNopSz 	    dd $-szNop
szPushad	    db 'PUSHAD',13,10
dwPushadSz	    dd $-szPushad
szAddHereYrPatch    db ';ADD HERE YOUR PATCH STRINGS',13,10
dwAddHereYrPatchSz  dd $-szAddHereYrPatch
szRest		    db 'REST',13,10
dwRestSz	    dd $-szRest
szPushOEP	    db 'PUSH OEP',13,10
dwPushOEPSz	    dd $-szPushOEP
szPushOUT	    db 'PUSH OUT',13,10
dwPushOUTSz	    dd $-szPushOUT
szRetn		    db 'RETN',13,10
dwRetnSz	    dd $-szRetn
szPopad 	    db 'POPAD',13,10
dwPopadSz	    dd $-szPopad
szNewLine	    db 13,10
dwNewLineSz	    dd $-szNewLine
szOUT		    db 'OUT='
dwOUTSz 	    dd $-szOUT
szOEP		    db 'OEP='
dwOEPSz 	    dd $-szOEP
szFREE		    db 'FREE='
dwFREESz	    dd $-szFREE
szFREEAUTO	    db 'FREE=AUTO'
dwFREEAUTOSz	    dd $-szFREEAUTO
szBIN		    db 'BIN='
dwBINSz 	    dd $-szBIN
szJmpEax	    db 'BIN=#FFE0#',13,10
dwJmpEaxSz	    dd $-szJmpEax
szFileOpenError     db 'EXPRESSOR.DLL Module: Can not open file!',0
szAllocError	    db 'EXPRESSOR.DLL Module: Can not allocate memory!',0
szInvalidPEError    db 'EXPRESSOR.DLL Module: The file is not a valid win32 PE file!',0
szCantFindAddrError db 'EXPRESSOR.DLL Module: Can not find the address! Maybe the file is not packed with ASPack?',0
szUnknownError	    db 'EXPRESSOR.DLL Module: Unknown error!',0

szBuffer	    rb 800h
szOEPBuffer	    rb 0Ch
szOUTBuffer	    rb 0Ch
szFREEBuffer	    rb 0Ch

section '.c' code readable executable

proc DllEntryPoint, hinstDLL,fdwReason,lpvReserved
   or	   eax,-1
   ret
endp

proc HzorInit ;Here we get the address of the string with filename of packed exe in EAX register
   mov	  [dwFileName],eax
   ;We can do here some other initializations if we need.. Return 0 in EAX if any error occures.
   or eax,-1
   retn
endp

proc HzorDoJob ;Here we get the handle of script window in EAX register
   mov	  [dwIdScript],eax
  ;=============================================================================
  ;If we want we can add there any lines, e.g. for patching CRC check of a packer
  ;szString db 'P,004050AB,EB',13,10,'P,004050BB,90',0
  ;...
  ;invoke  SendMessage,[dwIdScript],WM_SETTEXT,NULL,szString
  ;=============================================================================
   invoke SetFileAttributes,[dwFileName],0080h
   invoke CreateFile,[dwFileName],80000000h,0,0,3,0080h,0
   mov	  [dwFile],eax
   cmp	  eax,-1
   jnz	  @f
   invoke MessageBox,NULL,szFileOpenError,szErrorCap,MB_OK
   xor	  eax,eax
   retn
@@:
   invoke GetFileSize,[dwFile],0
   mov	  [dwFileSize],eax
   invoke GlobalAlloc,0000h,[dwFileSize]
   mov	  [dwMemptr],eax
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szAllocError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  _exit
@@:
   invoke ReadFile,[dwFile],[dwMemptr],[dwFileSize],dwRead,0
   invoke CloseHandle,[dwFile]
   mov	  edi,[dwMemptr]
   mov	  esi,edi
   add	  esi,[dwFileSize]
   dec	  esi
   mov	  ax,word [edi]
   cmp	  ax,[wMZ]
   jz	  @f
   invoke MessageBox,NULL,szInvalidPEError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  _exit
@@:
   add	  edi,3Ch
   mov	  eax,[edi]
   mov	  edi,[dwMemptr]
   add	  edi,eax
   mov	  eax,[edi]
   cmp	  eax,[dwPE]
   jz	  @f
   invoke MessageBox,NULL,szInvalidPEError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  _exit
@@:
   push   edi
   add	  edi,06h
   mov	  ax,word [edi]
   mov	  [dwSectNumber],ax
   add	  edi,2Eh
   push   dword [edi]
   pop	  [dwImageBase]
   pop	  edi
   push   edi
   add	  edi,03Ch
   push   dword [edi]
   pop	  [dwFileAlignment]
   pop	  edi
   mov	  eax,edi
   add	  eax,14h
   movzx  eax,word [eax]
   add	  eax,18h ;Size of PE Header
   mov	  [dwSectionsAddr],edi
   add	  [dwSectionsAddr],eax
   add	  edi,28h
   mov	  edi,[edi] ;Entry point RVA
   mov	  eax,edi
   call   rva2raw
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szUnknownError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  _exit
@@:
   mov	  edi,eax
   add	  edi,[dwMemptr]
   mov	  esi,[dwMemptr]
   add	  esi,[dwFileSize]
   dec	  esi
   mov	  al,8Bh ;first byte of signature
@@:
   inc	  edi
   cmp	  byte [edi],al
   jz	  _found_1
_continue_search:
   cmp	  edi,esi
   jb	  @b
;not found
   invoke MessageBox,NULL,szCantFindAddrError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  _exit

_found_1:
   push   esi
   push   edi
   cmp	  word [edi],458Bh
   jz	  @f
   cmp	  word [edi],858Bh
   jz	  _85_8B
   pop	  edi
   pop	  esi
   jmp	  _continue_search
_85_8B:
   add	  edi,3
@@:
   add	  edi,3
   cmp	  dword [edi],835B5E5Fh
   jz	  @f
   cmp	  dword [edi],815B5E5Fh
   jz	  @f
   pop	  edi
   pop	  esi
   jmp	  _continue_search
@@:
   add	  edi,4
   cmp	  byte [edi],0C4h
   jz	  @f
   pop	  edi
   pop	  esi
   jmp	  _continue_search
@@:
   add	  edi,2
   cmp	  byte [edi],5Dh
   jz	  @f
   add	  edi,3
   cmp	  byte [edi],5Dh
   jz	  @f
   pop	  edi
   pop	  esi
   jmp	  _continue_search
@@:
   pop	  edi
   pop	  esi
;found
   mov	  eax,edi
   add	  eax,5 ;now it's on pop ebx
   cmp	  byte [eax],5Bh ;pop ebx
   jz	  @f
   inc	  eax ;old version, now it aims to pop ebp
@@:
   push   eax
   or	  ecx,-1
@@:
   inc	  eax
   inc	  ecx
   cmp	  dword [eax],5E5FE0FFh ;jmp eax,pop edi,pop esi
   jnz	  @b
   pop	  eax
   mov	  [dwRipBytesAddr],eax
   inc	  ecx
   mov	  [dwRipBytesAddrSz],ecx
   sub	  eax,[dwMemptr]
   call   raw2va
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szUnknownError,szErrorCap,MB_OK
@@:

   mov	  edi,szOUTBuffer
   call   dword2hex

   mov	  edi,szBuffer

   mov	  esi,szFREEAUTO
   mov	  ecx,[dwFREEAUTOSz]
   rep	  movsb

   mov	  esi,szNewLine
   mov	  ecx,[dwNewLineSz]
   rep	  movsb

   mov	  esi,szOUT
   mov	  ecx,[dwOUTSz]
   rep	  movsb

   mov	  esi,szOUTBuffer
   call   str_len
   mov	  ecx,eax
   rep	  movsb

   mov	  esi,szNewLine
   mov	  ecx,[dwNewLineSz]
   rep	  movsb

   mov	  esi,szMainProcComm
   mov	  ecx,[dwMainProcCommSz]
   rep	  movsb

   mov	  esi,szProc
   mov	  ecx,[dwProcSz]
   rep	  movsb

   mov	  esi,szNop
   mov	  ecx,[dwNopSz]
   rep	  movsb

   mov	  esi,szBIN
   mov	  ecx,[dwBINSz]
   rep	  movsb

   mov	  al,'#'
   stosb

   mov	  esi,[dwRipBytesAddr]
   mov	  ecx,[dwRipBytesAddrSz]
   inc	  ecx
   dec	  esi
_next:
   inc	  esi
   dec	  ecx
   jz	  _finish
   xor	  eax,eax
   mov	  al,byte [esi]
   cmp	  eax,0Fh
   ja	  @f
   push   eax
   mov	  al,'0'
   stosb
   pop	  eax
@@:
   call   dword2hex
   dec	  edi
@@:
   inc	  edi
   cmp	  byte [edi],0
   jnz	  @b
   jmp	  _next

_finish:

   mov	  al,'#'
   stosb

   mov	  esi,szNewLine
   mov	  ecx,[dwNewLineSz]
   rep	  movsb

   mov	  esi,szAddHereYrPatch
   mov	  ecx,[dwAddHereYrPatchSz]
   rep	  movsb

   mov	  esi,szNewLine
   mov	  ecx,[dwNewLineSz]
   rep	  movsb

   mov	  esi,szJmpEax
   mov	  ecx,[dwJmpEaxSz]
   rep	  movsb

   mov	  esi,szEndp
   mov	  ecx,[dwEndpSz]
   rep	  movsb

   mov	  esi,szMainProcEndComm
   mov	  ecx,[dwMainProcEndCommSz]
   rep	  movsb

   mov	  al,0
   stosb

   invoke  SendMessage,[dwIdScript],WM_SETTEXT,NULL,szBuffer
   or	   eax,-1 ; mov eax,-1
_exit:
   push   eax
   invoke GlobalFree, [dwMemptr]
   pop	  eax
   retn
endp

proc HzorPluginInfo
   invoke MessageBox,NULL,szAboutMes,szAboutCap,MB_OK
   retn
endp

proc HzorIdentify
   invoke SetFileAttributes,[dwFileName],0080h
   invoke CreateFile,[dwFileName],80000000h,0,0,3,0080h,0
   mov	  [dwFile],eax
   cmp	  eax,-1
   jnz	  @f
   xor	  eax,eax
   retn
@@:
   invoke GetFileSize,[dwFile],0
   mov	  [dwFileSize],eax
   invoke GlobalAlloc,0000h,[dwFileSize]
   mov	  [dwMemptr],eax
   test   eax,eax
   jnz	  @f
   xor	  eax,eax
   jmp	  _ret
@@:
   invoke ReadFile,[dwFile],[dwMemptr],[dwFileSize],dwRead,0
   invoke CloseHandle,[dwFile]
   mov	  edi,[dwMemptr]
   mov	  esi,edi
   add	  esi,[dwFileSize]
   dec	  esi
   mov	  ax,word [edi]
   cmp	  ax,[wMZ]
   jz	  @f
   xor	  eax,eax
   jmp	  _ret
@@:
   add	  edi,3Ch
   mov	  eax,[edi]
   mov	  edi,[dwMemptr]
   add	  edi,eax
   mov	  eax,[edi]
   cmp	  eax,[dwPE]
   jz	  @f
   xor	  eax,eax
   jmp	  _ret
@@:
   push   edi
   add	  edi,06h
   mov	  ax,word [edi]
   mov	  [dwSectNumber],ax
   add	  edi,2Eh
   push   dword [edi]
   pop	  [dwImageBase]
   pop	  edi
   push   edi
   add	  edi,03Ch
   push   dword [edi]
   pop	  [dwFileAlignment]
   pop	  edi
   mov	  eax,edi
   add	  eax,14h
   movzx  eax,word [eax]
   add	  eax,18h ;Size of PE Header
   mov	  [dwSectionsAddr],edi
   add	  [dwSectionsAddr],eax
   add	  edi,28h
   mov	  edi,[edi] ;Entry point RVA
   mov	  eax,edi
   call   rva2raw
   test   eax,eax
   jnz	  @f
   xor	  eax,eax
   jmp	  _ret
@@:
   mov	  edi,eax
   add	  edi,[dwMemptr]
   mov	  esi,[dwMemptr]
   add	  esi,[dwFileSize]
   dec	  esi
   mov	  al,8Bh ;first byte of signature
@@:
   inc	  edi
   cmp	  byte [edi],al
   jz	  _found_2
_continue_search2:
   cmp	  edi,esi
   jb	  @b
;not found
   xor	  eax,eax
   jmp	  _ret

_found_2:
   push   esi
   push   edi
   cmp	  word [edi],458Bh
   jz	  @f
   cmp	  word [edi],858Bh
   jz	  _85_8B_2
   pop	  edi
   pop	  esi
   jmp	  _continue_search2
_85_8B_2:
   add	  edi,3
@@:
   add	  edi,3
   cmp	  dword [edi],835B5E5Fh
   jz	  @f
   cmp	  dword [edi],815B5E5Fh
   jz	  @f
   pop	  edi
   pop	  esi
   jmp	  _continue_search2
@@:
   add	  edi,4
   cmp	  byte [edi],0C4h
   jz	  @f
   pop	  edi
   pop	  esi
   jmp	  _continue_search2
@@:
   add	  edi,2
   cmp	  byte [edi],5Dh
   jz	  @f
   add	  edi,3
   cmp	  byte [edi],5Dh
   jz	  @f
   pop	  edi
   pop	  esi
   jmp	  _continue_search2
@@:
   pop	  edi
   pop	  esi
;found
   or	  eax,-1
_ret:
   retn
endp

; =========================================================================================
; (C) arnix [arnix@freenet.am]
proc raw2va
   push   esi
   push   edi
   push   ecx

   xor	  ecx,ecx
   mov	  cx,[dwSectNumber]
   mov	  edi,[dwSectionsAddr]
.next_section:
   push   eax

   push   dword [edi+0Ch]
   pop	  [dwVOffset]

   push   dword [edi+10h]
   pop	  eax
   xor	  edx,edx
   div	  [dwFileAlignment]
   mul	  [dwFileAlignment]
   add	  eax,[dwFileAlignment]
   mov	  [dwRSize],eax

   push   dword [edi+14h]
   pop	  eax
   xor	  edx,edx
   div	  [dwFileAlignment]
   mul	  [dwFileAlignment]
   mov	  [dwROffset],eax

   pop	  eax

   cmp	  eax,[dwROffset]
   jna	  @f
   mov	  esi,[dwRSize]
   add	  esi,[dwROffset]
   cmp	  eax,esi
   ja	  @f
   mov	  esi,[dwVOffset]
   add	  esi,eax
   mov	  eax,esi
   add	  eax,[dwImageBase]
   sub	  eax,[dwROffset]
   jmp	  .exit
@@:
   add	  edi,28h
   dec	  ecx
   jnz	  .next_section
;cant calculate
   xor	  eax,eax
.exit:
   pop	  ecx
   pop	  edi
   pop	  esi
retn
endp


; =========================================================================================
; (C) arnix [arnix@freenet.am]
proc rva2raw
   push   esi
   push   edi
   push   ecx

   xor	  ecx,ecx
   mov	  cx,[dwSectNumber]
   mov	  edi,[dwSectionsAddr]
.next_section:
   push   eax
   push   dword [edi+08h]
   pop	  [dwVSize]
   push   dword [edi+0Ch]
   pop	  [dwVOffset]
   push   dword [edi+14h]
   pop	  eax
   xor	  edx,edx
   div	  [dwFileAlignment]
   mul	  [dwFileAlignment]
   mov	  [dwROffset],eax
   pop	  eax

   cmp	  eax,[dwVOffset]
   jl	  @f
   mov	  esi,[dwVSize]
   add	  esi,[dwVOffset]
   cmp	  eax,esi
   jge	  @f
   sub	  eax,[dwVOffset]
   mov	  esi,[dwROffset]
   add	  esi,eax
   mov	  eax,esi
   jmp	  .exit

@@:
   add	  edi,28h
   dec	  ecx
   jnz	  .next_section
;cant calculate
   xor	  eax,eax
.exit:
   pop	  ecx
   pop	  edi
   pop	  esi
retn
endp


; =========================================================================================
; (C) arnix [arnix@freenet.am]
; Gets the dword value in EAX register and an address to a buffer to write the string in EDI (need max. 9 byte-length)
; Returns nothing, but the result is the zero-terminated string in address of EDI
proc dword2hex
   push    eax
   push    ecx
   push    edi

   push    10h
   pop	   ecx
   push    -30h
@@:
   xor	   edx,edx
   div	   ecx
   push    edx
   test    eax,eax
   jnz	   @b
.next:
   pop	   eax
   add	   al,30h
   cmp	   al,3Ah
   jb	   @f
   add	   al,07h
@@:
   stosb
   test    al,al
   jnz	   .next

   pop	   edi
   pop	   ecx
   pop	   eax
ret
endp

; =========================================================================================
; (C) arnix [arnix@freenet.am]
; Gets the address of zero terminated string in ESI register
; Returns the length in EAX register
proc str_len
   push    esi
   push    ecx

   or	   ecx,-1
@@:
   inc	   ecx
   lodsb
   test    al,al
   jnz	   @b

   push    ecx
   pop	   eax
   pop	   ecx
   pop	   esi
retn
endp

section '.e' export data readable

  export 'EXPRESSOR.DLL',\
	 HzorInit,'HzorInit',\
	 HzorDoJob,'HzorDoJob',\
	 HzorPluginInfo,'HzorPluginInfo',\
	 HzorIdentify,'HzorIdentify'

section '.r' fixups data discardable