; Project: HzorInline v1.3 beta build 20060824
; Author: arnix
; E-Mail: arnix@freenet.am
; URL: http://arnix.at.googlepages.com
; License: GNU GPL v2.1 (see COPYING.txt)
;
; You want to read comments describing the code? You better read the code ;)
;
; Successfully compiled with Fasm 1.64, 1.65, 1.66, 1.67.7
; You can get Fasm from http://flatassembler.net

format PE GUI 4.0
include '%fasminc%\win32a.inc'
entry start

; === [ Constants ] ==========================================================
ID_MAIN_DIALOG	   = 1
ID_STATIC_1	   = 101
ID_FILE_EDIT	   = 102
ID_FILE_BROWSE	   = 103
ID_STATIC_2	   = 104
ID_MODULE	   = 105
ID_EXECUTE_MODULE  = 106
ID_MODULE_INFO	   = 107
ID_STATIC_3	   = 108
ID_SCRIPT_EDIT	   = 109
ID_GROUP_1	   = 110
ID_PATCH_PE	   = 111
ID_GEN_CODE	   = 112
ID_RESERVED1	   = 113
ID_RESERVED2	   = 114
ID_GROUP_2	   = 115
ID_HELP 	   = 116
ID_ABOUT	   = 117
ID_EXIT 	   = 118

ID_ABOUT_DIALOG    = 2
ID_OK		   = 202

ID_ICON 	   = 500

DDL_DIRECTORY	   = 16



; === [ Imports' section ] ===================================================
section '.i' import data readable writeable

   library kernel32,	'KERNEL32.DLL',\
	   user32,	'USER32.DLL',\
	   comdlg32,	'COMDLG32.DLL'

	   include	'%fasminc%/apia/kernel32.inc'
	   include	'%fasminc%/apia/user32.inc'
	   include	'%fasminc%/apia/comdlg32.inc'

; === [ Resources section ] ==================================================
section '.r' resource from 'Resources.res' data readable

; === [ Data section ] =======================================================
section '.d' data readable writeable

; ====== [ Initialized data ] ================================================
_hWnd		    dd 0
hInstance	    dd 0
hModule 	    dd 0

HzorInit	    dd 0
HzorDoJob	    dd 0
HzorPluginInfo	    dd 0
HzorIdentify	    dd 0

dwStringPointer     dd 0
dwBufferPointer     dd 0
dwPatchPointer	    dd 0
dwInlinePointer     dd 0

_data_1:
dwVAFreeSpace	    dd 0
dw_R_VAFreeSpace    dd 0

dwPatchCount	    dd 0
dwJumpAddr	    dd 0
dwVAJumpAddr	    dd 0
dwPatchAddr	    dd 0
dwPatchNum	    dd 0
dwFreeSpaceRAW	    dd 0
dwParseEnd	    dd 0
dwAppend	    dd 0
dwMaxSize	    dd 0
dwStolenBytesCount  dd 0
bFreeCommandUsed    db 0

dwSectNumber	    dw 0
dwImageBase	    dd 0
dwSectionsAddr	    dd 0
dwVOffset	    dd 0
dwRSize 	    dd 0
dwVSize 	    dd 0
dwROffset	    dd 0
dwFileAlignment     dd 0
dwSecAddrPlusMem    dd 0

dwVA_OUT	    dd 0
dwRAW_OUT	    dd 0
dwVA_OEP	    dd 0
dwPROCHasBegun	    dd 0
dwProcPatchOK	    dd 0
dwEndpOK	    dd 0
_data_1_size = $ - _data_1

dwFile		    dd 0
dwFile2 	    dd 0
dwFileSize	    dd 0
dwMemptr	    dd 0
dwReadWrite	    dd 0

wMZ		    dw 'MZ'
dwPE		    dd 00004550h

ofn_struct	    dd 4Ch,0,0,ofn_filter,0,0,0
		    dd szFileName
		    dw 0200h,0
		    dd 0,0,0,szFcaption,01000h,0,0,0,0,0
ofn_struct2	    dd 4Ch,0,0,ofn_filter2,0,0,0
		    dd szFileName2
		    dw 0200h,0
		    dd 0,0,0,szFcaption2,01000h,0,0,0,0,0
szZeroString	    db 0
ofn_filter	    db 'Packed file',0,'*.*',0,0
ofn_filter2	    db 'ASM file',0,'*.asm',0,0
szHzorInit	    db 'HzorInit',0
szHzorDoJob	    db 'HzorDoJob',0
szHzorPluginInfo    db 'HzorPluginInfo',0
szHzorIdentify	    db 'HzorIdentify',0
lpszFileSpec	    db 'modules/*.dll',0
szHelp		    db 'Caution: All values in the script must be hexadecimal values! Without any prefixes and suffixes! Also do not wrie "0" before values that begins with a letter! Here is an example of a script:',13,10,13,10,\
		       'OUT=00403020',13,10,\
		       'FREE=0000ABCD',13,10,\
		       'OEP=00401000',13,10,\
		       'PROC',13,10,\
		       'NOP',13,10,\
		       'PUSHAD',13,10,\
		       'P,00405060,EB',13,10,\
		       'P,0040ABCD,90,90,90,90',13,10,\
		       'POPAD',13,10,\
		       'PUSH OEP',13,10,\
		       ';REST',13,10,\
		       ';PUSH OUT',13,10,\
		       'RETN',13,10,\
		       'ENDP',13,10,\
		       ';A COMMENT',13,10,13,10,\
		       'Please refer to the documentation which comes with this program for more info',0
szHelpCap	    db 'Help',0
szFcaption	    db 'Choose packed file',0
szFcaption2	    db 'Choose file to save to',0
szPluginsDir	    db 'modules\',0
szDoneCap	    db 'Done!',0
szCodeGenerated     db 'Code generated successfully!',0
szPatched	    db 'Patched successfully!',0
szErrorCap	    db 'Error',0
szCantLoadLibrary   db 'Can not load the module!',0
szCantFindProc	    db 'Invalid module!',0
szBadOutAddr	    db 'The address "XXXXXXXX" of "OUT=XXXXXXXX" command is invalid! It must contain characters "0"-"9","A"-"F" ONLY!',0
szInvalidJumpAddr   db 'Can not convert the Virtual Address that was returned by the module to file RAW address! Maybe the module returned incorrect address!',0
szIncorrectJumpAddr db 'The address that the module has returned is incorrect! The module works not properly!',0
szBadPatchLine	    db 'Invalid patch line! It must be like "P,XXXXXXXX,YY,YY,YY" where the XXXXXXXX is the address, YY-s are bytes to write in that address!',0
szBadFreeLine	    db 'The "Free=XXXXXXXX" command is invalid!',0
szRestInvalidPlace  db 'The "REST" command can not be placed before the "PROC" command!',0
szBinInvalidPlace   db 'The "BIN=YY,YY,YY" type command can not be placed before the "PROC" command!',0
szPushInvalidPlace  db 'The "PUSH OEP","PUSH OUT" and "PUSHAD" commands can not be placed before the "PROC" command!',0
szPushOEPNotFound   db 'The "PUSH OEP" command can not be placed before the "OEP=XXXXXXXX" command!',0
szPushOUTNotFound   db 'The "PUSH OUT" command can not be placed before the "OUT=XXXXXXXX" command!',0
szPopadInvalidPlace db 'The "POPAD" command can not be placed before the "PROC" command!',0
szDontDefineMax     db 'You have defined "MAX_SIZE" variable, but you can use it only with "FREE=AUTO"!',0
szVeryBig	    db 'Your patch is very big, please choose another free space and change the "MAX_SIZE" variable, or remove it and choose "FREE=APPEND" to append the patch at the end of the file.',0
szUseOutAfterFree   db 'Please use "OUT=XXXXXXXX" command after the "FREE=XXXXXXXX" command.',0
szModuleCantWork    db 'The module returned error code!',0
szBadScript	    db 'Bad script!',0
szTooLongScript     db 'The script is too big!',0
szFileOpenError     db 'Can not open file!',0
szFileSaveError     db 'Can not write to file!',0
szAllocError	    db 'Can not allocate memory!',0
szInvalidPEError    db 'The file is not a valid win32 PE file!',0
szCantFindFreeSpace db 'The free spcae in the packed file is not enough to make an inline patch! Try to patch less bytes. Or you can specify the free space manually by the "FREE=XXXXXXXX" command where the "XXXXXXXX" is a RAW address in the packed file.',0
szPNotFound	    db 'Can not find any "P,XXXXXXXX,YY,YY" type command!',0
szBadHex	    db 'Bad HEX value...',0
szBadOEPLine	    db '"OEP=XXXXXXXX" command is invalid!',0
szProcNotFound	    db 'Can not find "PROC" command',0
szEndpNotFound	    db 'Can not find "ENDP" command!',0
szText1 	    db ';MODULE: ',0
szText2 	    db ';MODULE GENERATED CODE START',0
szText3 	    db ';MODULE GENERATED CODE END',0
szDb		    db ' db ',0
szDd		    db ' dd ',0
szAddr		    db 'addr_',0
szData		    db 'data_',0
szDataSize	    db 'data_size_',0
bNop		    db 90h
bPushad 	    db 60h
bMovEdiXXXXXXXX     db 0BFh
bMovAlXX	    db 0B0h
bMovByteXXXXXXXX    db 0C6h,05h
szMovByteXXXXXXXX   dd $-bMovByteXXXXXXXX
bMovWordXXXXXXXX    db 066h,0C7h,05h
szMovWordXXXXXXXX   dd $-bMovWordXXXXXXXX
bMovDwordXXXXXXXX   db 0C7h,05h
szMovDwordXXXXXXXX  dd $-bMovDwordXXXXXXXX
bJmp		    db 0E9h
bStosb		    db 0AAh
bPopad		    db 61h
bPush		    db 68h
bRet		    db 0C3h


; ====== [ Uninitialized data ] ==============================================
szModule	     rb 0FFh
szModuleName	     rb 0FFh
szFileName	     rb 0FFh
szBakFileName	     rb 0FFh
szFileName2	     rb 0FFh
_reserve:
szBuffer	     rb 400h
szStringResultBuffer rb 400h
szPatchBuffer	     rb 400h
szInlineBuffer	     rb 400h
szLineBuffer	     rb 0FFh
szPatchAddrRAW	     rb 0Ch
szPatchByte	     rb 0Ch
szInlineByte	     rb 0Ch
szPatchNumBuffer     rb 0Ch
szStolenBuffer	     rb 400h
szJumpToInlineBuffer rb 400h
szRAW_OUT	     rb 0Ch
szModuleNames	     rb 400h
_reserve_size = $ - _reserve
; === [ Code section ] ========================================================
section '.c' code readable executable

proc DoMainJob
   mov	   edi,_reserve
   dec	   edi
   mov	   ecx,_reserve_size
   inc	   ecx
@@:
   dec	   ecx
   inc	   edi
   mov	   byte [edi],00h
   test    ecx,ecx
   jnz	   @b

   mov	   edi,_data_1
   dec	   edi
   mov	   ecx,_data_1_size
   inc	   ecx
@@:
   dec	   ecx
   inc	   edi
   mov	   byte [edi],00h
   test    ecx,ecx
   jnz	   @b

   mov	   [dwPatchPointer],szPatchBuffer
   mov	   [dwInlinePointer],szInlineBuffer
   mov	   [dwPatchNum],0
   mov	   [dwPROCHasBegun],0
   mov	   [dwProcPatchOK],0
   mov	   [dwEndpOK],0
   mov	   [dwFreeSpaceRAW],0
   mov	   [dwVA_OEP],0
   mov	   [dwVA_OUT],0
   mov	   [dwParseEnd],0
   mov	   [dwAppend],0
   mov	   [dwMaxSize],0
   mov	   [dwStolenBytesCount],0
   mov	   [bFreeCommandUsed],0
   invoke  SendDlgItemMessage,[_hWnd],ID_SCRIPT_EDIT,WM_GETTEXTLENGTH,NULL,NULL
   test    eax,eax
   jnz	   @f
   cmp	   eax,800h
   jb	   @f
   invoke  MessageBox,NULL,szTooLongScript,szErrorCap,MB_OK or MB_ICONHAND
   jmp	   processed
@@:
   inc	   eax
   invoke  SendDlgItemMessage,[_hWnd],ID_SCRIPT_EDIT,WM_GETTEXT,eax,szBuffer
   invoke  SendDlgItemMessage,[_hWnd],ID_SCRIPT_EDIT,EM_GETLINECOUNT,NULL,NULL
   cmp	   eax,1
   ja	   @f
   invoke  MessageBox,NULL,szBadScript,szErrorCap,MB_OK or MB_ICONHAND
   jmp	   processed
@@:
   mov	   ecx,eax
   call    LoadFile
   test    eax,eax
   jnz	   @f
   jmp	   processed
@@:
   mov	   edi,szBuffer

next_line:
   test    ecx,ecx
   jz	   done_parse
   mov	   esi,szLineBuffer
next_char:
   mov	   bl,[edi]
   cmp	   bl,13
   jz	   .line_end
   cmp	   bl,0
   jz	   .line_end
   mov	   [esi],bl
   inc	   edi
   inc	   esi
   jmp	   next_char
.line_end:
   mov	   byte [esi],0
   mov	   esi,szLineBuffer
@@:
   dec	   ecx
   inc	   edi
   inc	   edi
   cmp	   byte [edi],13
   jz	   @b

   cmp	   [dwParseEnd],1
   jz	   done_parse
   cmp	   byte [esi],0
   jnz	   @f
   mov	   [dwParseEnd],1
@@:
   cmp	   byte [esi],';'
   jz	   next_line
   cmp	   dword [esi], 'FREE'
   jz	   _set_free_space
   cmp	   dword [esi], 'MAX_'
   jz	   _set_max
   cmp	   dword [esi], 'OEP='
   jz	   _set_oep
   cmp	   dword [esi],'OUT='
   jz	   _set_out_address
   cmp	   dword [esi],'OUT_'
   jz	   _set_out_code
   cmp	   dword [esi], 'REST'
   jz	   _restore
   cmp	   dword [esi], 'BIN='
   jz	   _bin
   cmp	   dword [esi],'PROC'
   jz	   _proc_start
   cmp	   word [esi],'P,'
   jz	   _patch
   cmp	   dword [esi],'PUSH'
   jz	   _push
   cmp	   dword [esi],'POPA'
   jz	   _popad
   cmp	   dword [esi],'RETN'
   jz	   _retn
   cmp	   word [esi],'NO'
   jz	   _nop
   cmp	   dword [esi],'ENDP'
   jz	   _proc_end
   invoke  MessageBox,NULL,szBadScript,szErrorCap,MB_OK or MB_ICONHAND
   jmp	   done_parse

;===========================================================================
_set_free_space:
   push    esi
   push    edi
   push    ecx

   add	   esi,4
   cmp	   byte [esi],'='
   jz	   @f
   invoke  MessageBox,NULL,szBadFreeLine,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   inc	   esi
   mov	   [bFreeCommandUsed],1
   cmp	   dword [esi], 'AUTO'
   jnz	   .set_fixed_free
   mov	   [dwFreeSpaceRAW],0
   mov	   [dwAppend],0
   jmp	   .set_free_space_exit

.set_fixed_free:
   cmp	   dword [esi], 'APPE'
   jnz	   .set_fixed_free2
   push    [dwFileSize]
   pop	   [dwFreeSpaceRAW]
   mov	   [dwAppend],1
   jmp	   .set_free_space_exit
.set_fixed_free2:
   mov	   eax,esi
   call    hex2dword
   cmp	   eax,-1
   jnz	   @f
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   mov	   [dwFreeSpaceRAW],eax
   mov	   [dwAppend],0

.set_free_space_exit:
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   next_line
;===========================================================================
;===========================================================================
_set_max:
   push    esi
   push    edi
   push    ecx

   add	   esi,4
   cmp	   dword [esi],'SIZE'
   jz	   @f
   invoke  MessageBox,NULL,szBadFreeLine,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   add	   esi,4
   cmp	   byte [esi],'='
   jz	   @f
   invoke  MessageBox,NULL,szBadFreeLine,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   inc	   esi
   mov	   bl,byte [esi+4]
   mov	   byte [esi+4],0
   mov	   eax,esi
   call    hex2dword
   cmp	   eax,-1
   jnz	   @f
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   mov	   [dwMaxSize],eax

   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   next_line
;===========================================================================
;===========================================================================
_set_oep:
   push    esi
   push    edi
   push    ecx

   add	   esi,4

   mov	   eax,esi
   call    hex2dword
   cmp	   eax,-1
   jnz	   @f
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   mov	   [dwVA_OEP],eax

   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   next_line
;===========================================================================
;===========================================================================
_proc_start:
   push    eax
   mov	   eax,[dwPatchPointer]
   mov	   byte [eax],0
   mov	   eax,[dwInlinePointer]
   mov	   byte [eax],0
   pop	   eax
   mov	   [dwPROCHasBegun],1
   jmp	   next_line
;===========================================================================
;===========================================================================
_set_out_address:
   push    edi
   push    esi
   push    ecx

   cmp	   [bFreeCommandUsed],1
   jz	   @f
   invoke  MessageBox,NULL,szUseOutAfterFree,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   esi
   pop	   edi
   jmp	   done_parse
@@:
   mov	   eax,esi
   add	   eax,4
   call    hex2dword
   cmp	   eax,-1
   jnz	   @f
   invoke  MessageBox,NULL,szBadOutAddr,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   esi
   pop	   edi
   jmp	   done_parse
@@:
   mov	   [dwVA_OUT],eax
   call    va2raw
   test    eax,eax
   jnz	   @f
   invoke  MessageBox,NULL,szInvalidJumpAddr,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   esi
   pop	   edi
   jmp	   done_parse
@@:
   mov	   [dwRAW_OUT],eax

   pop	   ecx
   pop	   esi
   pop	   edi
   jmp	   next_line
;===========================================================================
;===========================================================================
_set_out_code:
   push    edi
   push    esi
   push    ecx
   add	   esi,4
   cmp	   dword [esi],'CODE'
   jz	   @f
   invoke  MessageBox,NULL,szBadScript,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   esi
   pop	   edi
   jmp	   done_parse
@@:
   mov	   edi,szJumpToInlineBuffer
   add	   esi,3
   xor	   ecx,ecx
   mov	   bl,byte [esi+2]
   cmp	   bl,'#'
   jz	   @f
   dec	   esi
.set_out_code_back0:
   add	   esi,3
   mov	   bl,byte [esi+2]
   mov	   byte [esi+2],00h
   mov	   eax,esi
   call    hex2dword
   cmp	   eax,-1
   jnz	   .f0
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
.f0:
   stosb
   mov	   byte [esi+2],bl
   inc	   ecx
   cmp	   bl,0
   jz	   .set_out_code_exit
   cmp	   bl,','
   jz	   .set_out_code_back0
   invoke  MessageBox,NULL,szBadScript,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse

@@:
   inc	   esi
.set_out_code_back:
   add	   esi,2
   mov	   bl,byte [esi+2]
   mov	   byte [esi+2],00h
   mov	   eax,esi
   call    hex2dword
   cmp	   eax,-1
   jnz	   @f
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   stosb
   mov	   byte [esi+2],bl
   inc	   ecx
   cmp	   bl,'#'
   jnz	   .set_out_code_back
.set_out_code_exit:
   mov	   [dwStolenBytesCount],ecx
   pop	   ecx
   pop	   esi
   pop	   edi
   jmp	   next_line
;===========================================================================
;===========================================================================
_restore:
   push    edi
   push    esi
   push    ecx

   cmp	   [dwStolenBytesCount],0
   jnz	   @f
   mov	   ebx,5
   jmp	   __f11
@@:
   mov	   ebx,[dwStolenBytesCount]
__f11:
   mov	   edi,szStolenBuffer
   mov	   esi,bMovEdiXXXXXXXX
   movsb

   mov	   esi,dwVA_OUT
   movsd

   mov	   esi,[dwRAW_OUT]
   add	   esi,[dwMemptr]

   mov	   ecx,ebx
   inc	   ecx
   dec	   esi
rest_next:
   inc	   esi
   dec	   ecx
   jz	   rest_finish

   push    esi
   mov	   esi,bMovAlXX
   movsb
   pop	   esi

   mov	   al,byte [esi]
   stosb

   push    esi
   mov	   esi,bStosb
   movsb
   pop	   esi
   jmp	   rest_next

rest_finish:

   mov	   esi,szStolenBuffer
   mov	   edi,[dwInlinePointer]
   cmp	   [dwVA_OUT],0
   jnz	   @f
   invoke  MessageBox,NULL,szRestInvalidPlace,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   esi
   pop	   edi
   jmp	   done_parse
@@:
   mov	   ecx,ebx
   mov	   eax,00000003h
   mul	   ecx
   add	   eax,5
   mov	   ecx,eax

   rep	   movsb

   mov	   [dwInlinePointer],edi

   pop	   ecx
   pop	   esi
   pop	   edi
   jmp	   next_line
;===========================================================================
;===========================================================================
_bin:
   push    esi
   push    edi
   push    ecx

   cmp	   [dwPROCHasBegun],0
   jnz	   @f
   invoke  MessageBox,NULL,szBinInvalidPlace,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   mov	   edi,[dwInlinePointer]
   add	   esi,2

   mov	   bl,byte [esi+2]
   cmp	   bl,'#'
   jz	   @f
   dec	   esi
.bin_back0:
   add	   esi,3
   mov	   bl,byte [esi+2]
   mov	   byte [esi+2],00h
   mov	   eax,esi
   call    hex2dword
   cmp	   eax,-1
   jnz	   .f00
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
.f00:
   stosb
   mov	   byte [esi+2],bl
   cmp	   bl,0
   jz	   .bin_exit
   cmp	   bl,','
   jz	   .bin_back0
   invoke  MessageBox,NULL,szBadScript,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse

@@:
   inc	   esi
.bin_back:
   add	   esi,2
   mov	   bl,byte [esi+2]
   mov	   byte [esi+2],00h
   mov	   eax,esi
   call    hex2dword
   cmp	   eax,-1
   jnz	   @f
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   stosb
   mov	   byte [esi+2],bl
   inc	   ecx
   cmp	   bl,'#'
   jnz	   .bin_back

.bin_exit:

   mov	   [dwInlinePointer],edi
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   next_line
;===========================================================================
;===========================================================================
_push:
   push    esi
   push    edi
   push    ecx

   cmp	   [dwPROCHasBegun],0
   jnz	   @f
   invoke  MessageBox,NULL,szPushInvalidPlace,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   mov	   edi,[dwInlinePointer]
   add	   esi,4
   cmp	   word [esi],'AD' ;PUSHAD
   jnz	   .push_oep
   mov	   esi,bPushad
   movsb
   mov	   [dwInlinePointer],edi
   jmp	   .push_exit
.push_oep:
   cmp	   dword [esi],' OEP' ;PUSH OEP
   jnz	   .push_out

   cmp	   [dwVA_OEP],0
   jnz	   @f
   mov	   eax,[dwInlinePointer]
   sub	   eax,szInlineBuffer
   call    seek_free_space
   test    eax,eax
   jnz	   @f
   invoke  MessageBox,NULL,szPushOEPNotFound,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   mov	   esi,bPush
   movsb

   mov	   esi,dwVA_OEP
   movsd

   mov	   [dwInlinePointer],edi
   jmp	   .push_exit

.push_out:
   cmp	   dword [esi],' OUT'
   jnz	   .push_error

   cmp	   [dwVA_OUT],0
   jnz	   @f
   invoke  MessageBox,NULL,szPushOUTNotFound,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   mov	   esi,bPush
   movsb

   mov	   esi,dwVA_OUT
   movsd

   mov	   [dwInlinePointer],edi
   jmp	   .push_exit

.push_error:
   invoke  MessageBox,NULL,szBadScript,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse

.push_exit:
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   next_line
;===========================================================================
;===========================================================================
_popad:
   push    esi
   push    edi
   push    ecx

   cmp	   [dwPROCHasBegun],0
   jnz	   @f
   invoke  MessageBox,NULL,szPopadInvalidPlace,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   mov	   edi,[dwInlinePointer]
   add	   esi,4
   cmp	   byte [esi],'D' ;POPAD
   jnz	   .popad_error
   mov	   esi,bPopad
   movsb

   mov	   [dwInlinePointer],edi
   jmp	   .popad_exit

.popad_error:
   invoke  MessageBox,NULL,szBadScript,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse

.popad_exit:
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   next_line
;===========================================================================
;===========================================================================
_retn:
   push    esi
   push    edi
   push    ecx

   mov	   edi,[dwInlinePointer]

   cmp	   byte [esi+4],0
   jz	   @f
   invoke  MessageBox,NULL,szBadScript,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   mov	   esi,bRet
   movsb

   mov	   [dwInlinePointer],edi

   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   next_line
;===========================================================================
;===========================================================================
_nop:
   push    esi
   push    edi
   push    ecx

   inc	   esi
   inc	   esi
   cmp	   byte [esi],'P' ;NOP
   jz	   @f
   invoke  MessageBox,NULL,szBadScript,szErrorCap,MB_OK or MB_ICONHAND
   jmp	   done_parse
@@:

   mov	   edi,[dwInlinePointer]

   mov	   esi,bNop
   movsb

   mov	   [dwInlinePointer],edi

   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   next_line
;===========================================================================
;===========================================================================
_patch:
   push    esi
   push    edi
   push    ecx

   add	   esi,2
   cmp	   byte [esi+8],','
   jz	   @f
   invoke  MessageBox,NULL,szBadPatchLine,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   mov	   bl,byte [esi+8]
   mov	   byte [esi+8],00h
   mov	   eax,esi
   call    hex2dword
   cmp	   eax,-1
   jnz	   @f
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   mov	   byte [esi+8],bl
   test    eax,eax
   jnz	   @f
   invoke  MessageBox,NULL,szBadPatchLine,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   add	   esi,08h
   cmp	   [dwPROCHasBegun],0
   jnz	   PROCHasBegun
   call    va2raw
   mov	   edi,[dwPatchPointer]
   stosd ;Patch Address

; [ Caluclating the number of bytes to patch ]
   xor	   eax,eax
   inc	   eax
   push    esi
@@:
   inc	   esi
   cmp	   byte [esi+2],00h
   jz	   @f
   inc	   eax
   inc	   esi
   inc	   esi
   jmp	   @b
@@:
   stosd ;The number of bytes to patch
   pop	   esi
   dec	   esi
   dec	   esi
; [ Caluclating end ]

back1:
   inc	   esi
   inc	   esi
   inc	   esi
   mov	   bl,byte [esi+2]
   mov	   byte [esi+2],00h
   mov	   eax,esi
   call    hex2dword
   cmp	   eax,-1
   jnz	   @f
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   stosb ;Byte to patch
   mov	   byte [esi],bl
   cmp	   byte [esi],0
   jz	   done_line_parse_1
   cmp	   byte [esi],','
   jz	   back1
   invoke  MessageBox,NULL,szBadPatchLine,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse

PROCHasBegun:
   mov	   [dwProcPatchOK],1
   mov	   [dwPatchAddr],eax
   mov	   edi,[dwInlinePointer]

; [ Caluclating the number of bytes to patch ]
   xor	   eax,eax
   inc	   eax
   push    esi
@@:
   inc	   esi
   cmp	   byte [esi+2],00h
   jz	   @f
   inc	   eax
   inc	   esi
   inc	   esi
   jmp	   @b
@@:
   pop	   esi
; [ Caluclating end]

   cmp	   eax,1
   jnz	   @f
   push    esi
   mov	   esi,bMovByteXXXXXXXX
   mov	   ecx,[szMovByteXXXXXXXX]
   rep	   movsb
   mov	   esi,dwPatchAddr
   movsd
   pop	   esi
   inc	   esi
   mov	   byte [esi+2],00h
   mov	   eax,esi
   call    hex2dword
   cmp	   eax,-1
   jnz	   .f1
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
.f1:
   stosb
   jmp	   done_line_parse_2

@@:
   cmp	   eax,2
   jnz	   @f
   push    esi
   mov	   esi,bMovWordXXXXXXXX
   mov	   ecx,[szMovWordXXXXXXXX]
   rep	   movsb
   mov	   esi,dwPatchAddr
   movsd
   pop	   esi

   inc	   esi
   mov	   byte [esi+2],00h
   mov	   eax,esi
   call    hex2dword
   cmp	   eax,-1
   jnz	   .f2
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
.f2:
   mov	   bl,al
   inc	   esi
   inc	   esi
   inc	   esi
   mov	   eax,esi
   mov	   byte [esi+2],00h
   call    hex2dword
   cmp	   eax,-1
   jnz	   .f22
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
.f22:
   stosb
   mov	   al,bl
   stosb
   jmp	   done_line_parse_2
@@:
   cmp	   eax,4
   jnz	   @f
   push    esi
   mov	   esi,bMovDwordXXXXXXXX
   mov	   ecx,[szMovDwordXXXXXXXX]
   rep	   movsb
   mov	   esi,dwPatchAddr
   movsd
   pop	   esi
   inc	   esi
   mov	   byte [esi+2],00h
   mov	   eax,esi
   call    hex2dword
   cmp	   eax,-1
   jnz	   .f3
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
.f3:
   mov	   bl,al
   shl	   ebx,8
   inc	   esi
   inc	   esi
   inc	   esi
   mov	   eax,esi
   mov	   byte [esi+2],0
   call    hex2dword
   cmp	   eax,-1
   jnz	   .f33
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
.f33:
   mov	   bl,al
   shl	   ebx,8
   inc	   esi
   inc	   esi
   inc	   esi
   mov	   eax,esi
   mov	   byte [esi+2],0
   call    hex2dword
   cmp	   eax,-1
   jnz	   .f333
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
.f333:
   mov	   bl,al
   inc	   esi
   inc	   esi
   inc	   esi
   mov	   eax,esi
   mov	   byte [esi+2],0
   call    hex2dword
   cmp	   eax,-1
   jnz	   .f3333
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
.f3333:
   stosb
   mov	   al,bl
   stosb
   shr	   ebx,8
   mov	   al,bl
   stosb
   shr	   ebx,8
   mov	   al,bl
   stosb
   jmp	   done_line_parse_2
@@:
   mov	   ecx,eax
   push    esi

   mov	   esi,bMovEdiXXXXXXXX
   movsb
   mov	   esi,dwPatchAddr
   movsd

   pop	   esi
   inc	   esi
   inc	   ecx
.next_patch_byte2:
   dec	   ecx
   jz	   done_line_parse_2

   push    esi
   mov	   esi,bMovAlXX
   movsb
   pop	   esi
   mov	   byte [esi+2],00h
   mov	   eax,esi
   call    hex2dword
   cmp	   eax,-1
   jnz	   @f
   invoke  MessageBox,NULL,szBadHex,szErrorCap,MB_OK or MB_ICONHAND
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   done_parse
@@:
   stosb
   inc	   esi
   inc	   esi
   inc	   esi

   push    esi

   mov	   esi,bStosb
   movsb

   pop	   esi

   jmp	   .next_patch_byte2

done_line_parse_1:
   mov	   [dwPatchPointer],edi
   jmp	   done_line_parse
done_line_parse_2:
   mov	   [dwInlinePointer],edi
done_line_parse:
   pop	   ecx
   pop	   edi
   pop	   esi
   jmp	   next_line
;===========================================================================
;===========================================================================
_proc_end:
   push    esi
   push    edi
   push    ecx

   cmp	   [dwPROCHasBegun],0
   jnz	   @f
   pop	   ecx
   pop	   edi
   pop	   esi
   invoke  MessageBox,NULL,szProcNotFound,szErrorCap,MB_OK
   jmp	   done_parse
@@:
   cmp	   [dwProcPatchOK],0
   jnz	   @f
   pop	   ecx
   pop	   edi
   pop	   esi
   invoke  MessageBox,NULL,szPNotFound,szErrorCap,MB_OK
   jmp	   done_parse
@@:

   mov	   ebx,[dwInlinePointer]
   sub	   ebx,szInlineBuffer
   add	   ebx,6 ;for push xxxxxxxx, retn
   cmp	   [dwAppend],0
   jz	   @f
   pushad
   invoke  SetFilePointer,[dwFile],3Ch,0,0
   invoke  ReadFile,[dwFile],dwAppend,4,dwReadWrite,0
   push    [dwAppend]
   add	   [dwAppend],6
   invoke  SetFilePointer,[dwFile],[dwAppend],0,0
   mov	   [dwAppend],0
   invoke  ReadFile,[dwFile],dwAppend,2,dwReadWrite,0
   xor	   eax,eax
   mov	   ax,word [dwAppend]
   pop	   [dwAppend]
   add	   [dwAppend],0F8h ;sections header starts here
   add	   [dwAppend],28h
   add	   [dwAppend],10h
   push    [dwAppend]
   invoke  SetFilePointer,[dwFile],[dwAppend],0,0
   invoke  ReadFile,[dwFile],dwAppend,4,dwReadWrite,0
   mov	   ecx,[dwAppend]
   add	   ecx,ebx
   sub	   ecx,6
   pop	   eax
   mov	   edi,[dwPatchPointer]
   stosd
   mov	   eax,4
   stosd
   mov	   eax,ecx
   stosb
   shr	   eax,8
   stosb
   shr	   eax,8
   stosb
   shr	   eax,8
   stosb
   mov	   [dwPatchPointer],edi
   popad

@@:
   cmp	   [dwFreeSpaceRAW],0
   jz	   @f
   mov	   eax,[dwFreeSpaceRAW]
   jmp	   free_space_defined2
@@:
   cmp	   [dwMaxSize],0
   jz	   @f
   pop	   ecx
   pop	   edi
   pop	   esi
   invoke  MessageBox,NULL,szDontDefineMax,szErrorCap,MB_OK
   jmp	   done_parse
@@:
   mov	   eax,ebx
   call    seek_free_space
   test    eax,eax
   jnz	   @f
   pop	   ecx
   pop	   edi
   pop	   esi
   invoke  MessageBox,NULL,szCantFindFreeSpace,szErrorCap,MB_OK
   jmp	   done_parse
@@:
free_space_defined2:
   mov	   [dwFreeSpaceRAW],eax

   cmp	   [dwStolenBytesCount],0
   jnz	   @f
   push    ebx
   mov	   [dwStolenBytesCount],5
   mov	   edi,szJumpToInlineBuffer

   mov	   ebx,[dwVA_OUT]
   add	   ebx,5

   mov	   eax,[dwFreeSpaceRAW]
   push    ebx
   call    raw2va
   pop	   ebx
   sub	   eax,ebx
   mov	   [dw_R_VAFreeSpace],eax

   mov	   esi,bJmp
   movsb

   mov	   esi,dw_R_VAFreeSpace
   movsd
   pop	   ebx
@@:
   cmp	   [dwMaxSize],0
   jz	   @f
   cmp	   [dwMaxSize],ebx
   jae	   @f
   pop	   ecx
   pop	   edi
   pop	   esi
   invoke  MessageBox,NULL,szVeryBig,szErrorCap,MB_OK
   jmp	   done_parse
@@:

   invoke  CloseHandle, [dwFile]
   or	   eax,-1
   pop	   ecx
   pop	   edi
   pop	   esi
retn

done_parse:
   invoke  CloseHandle, [dwFile]
retn
endp


proc AboutProc,hWnd,msg,wparam,lparam
   push    ebx esi edi

   cmp	   [msg],WM_COMMAND
   jz	   about_wmcommand
   cmp	   [msg],WM_CLOSE
   jz	   about_wmclose
   xor	   eax,eax
   jmp	   about_finish

about_wmcommand:
   mov	   eax,[wparam]
   cmp	   eax,ID_OK
   jz	   about_wmclose

   invoke  DefWindowProc,[hWnd],[msg],[wparam],[lparam]
   jmp	   about_processed
about_wmclose:
   invoke  EndDialog,[hWnd],1
   jmp	   about_processed
about_processed:
   mov	   eax,1

about_finish:
   pop	   edi esi ebx
   ret
endp

start:
   invoke GetModuleHandle,0
   mov	   [hInstance],eax

   invoke DialogBoxParam,eax,ID_MAIN_DIALOG,0,WindowProc,0
   invoke ExitProcess,eax

proc WindowProc, hWnd,msg,wparam,lparam
   push    ebx esi edi

   push    [hWnd]
   pop	   [_hWnd]
   cmp	   [msg],WM_INITDIALOG
   jz	   wminit
   cmp	   [msg],WM_COMMAND
   jz	   wmcommand
   cmp	   [msg],WM_CLOSE
   jz	   wmclose
   xor	   eax,eax
   jmp	   finish

wminit:
   invoke  LoadImage, [hInstance], ID_ICON, IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR
   invoke  SendMessage,[hWnd],WM_SETICON,ICON_SMALL,eax
   invoke  LoadImage, [hInstance], ID_ICON, IMAGE_ICON, 32, 32, LR_DEFAULTCOLOR
   invoke  SendMessage, [hWnd], WM_SETICON, ICON_BIG, eax
   invoke  SendDlgItemMessage,[hWnd],ID_MODULE,CB_DIR,FILE_ATTRIBUTE_ARCHIVE or DDL_DIRECTORY,lpszFileSpec
   jmp	   processed

wmcommand:
   mov	   eax,[wparam]
   cmp	   eax,ID_EXIT
   jz	   wmclose
   cmp	   eax,ID_ABOUT
   jz	   idabout
   cmp	   eax,ID_HELP
   jz	   idhelp
   cmp	   eax,ID_MODULE_INFO
   jz	   idmoduleinfo
   cmp	   eax,ID_FILE_BROWSE
   jz	   idfilebrowse
   cmp	   eax,ID_EXECUTE_MODULE
   jz	   idexecutemodule
   cmp	   eax,ID_PATCH_PE
   jz	   idpatchpe
   cmp	   eax,ID_GEN_CODE
   jz	   idgencode

   invoke  DefWindowProc,[hWnd],[msg],[wparam],[lparam]
   jmp	   processed

wmclose:
   invoke  EndDialog,[hWnd],1
   jmp	   processed

idabout:
   invoke  DialogBoxParam,[hInstance],ID_ABOUT_DIALOG,[hWnd],AboutProc,0
   jmp	   processed

idhelp:
   invoke  MessageBox,NULL,szHelp,szHelpCap,MB_OK
   jmp	   processed

idmoduleinfo:
   mov	   eax,[hWnd]
   call    LoadDll
   test    eax,eax
   jnz	   @f
   jmp	   processed
@@:
   call    [HzorPluginInfo]
   call    UnLoadDll

   jmp	   processed

idfilebrowse:
   invoke  GetOpenFileName,ofn_struct
   invoke  Sleep,100h
   invoke  SetDlgItemText,[hWnd],ID_FILE_EDIT,szFileName
   cmp	   byte [szFileName],0
   jz	   processed

   invoke  GetDlgItem,[hWnd],ID_MODULE
   invoke  SendMessage,eax,CB_GETCOUNT,NULL,NULL
   cmp	   eax,CB_ERR
   jnz	   @f
   jmp	   processed
@@:
   test    eax,eax
   jnz	   @f
   jmp	   processed
@@:
   pushad
   invoke  SendDlgItemMessage,[hWnd],ID_SCRIPT_EDIT,WM_SETTEXT,NULL,szZeroString
   popad
   mov	   ecx,eax
.next_module_ident:
   dec	   ecx
   push    ecx
   push    ecx
   invoke  GetDlgItem,[hWnd],ID_MODULE
   pop	   ecx
   invoke  SendMessage,eax,CB_SETCURSEL,ecx,NULL
   pop	   ecx
   push    ecx
   mov	   eax,[hWnd]
   call    LoadDll
   pop	   ecx
   test    eax,eax
   jnz	   @f
   invoke  GetDlgItem,[hWnd],ID_MODULE
   invoke  SendMessage,eax,CB_SETCURSEL,-1,NULL
   jmp	   processed
@@:
   push    ecx
   mov	   eax,szFileName
   call    [HzorInit]
   call    [HzorIdentify]
   push    eax
   call    UnLoadDll
   pop	   eax
   pop	   ecx
   cmp	   eax,-1
   jz	   .its_ok
   test    ecx,ecx
   jnz	   .next_module_ident
   invoke  GetDlgItem,[hWnd],ID_MODULE
   invoke  SendMessage,eax,CB_SETCURSEL,-1,NULL
.its_ok:
   jmp	   processed

idexecutemodule:
   mov	   eax,[hWnd]
   call    LoadDll
   test    eax,eax
   jnz	   @f
   jmp	   processed
@@:
   mov	   eax,szFileName
   call    [HzorInit]
   test    eax,eax
   jnz	   @f
   invoke  MessageBox,NULL,szModuleCantWork,szErrorCap,MB_OK or MB_ICONHAND
   jmp	   processed
@@:
   invoke  SendDlgItemMessage,[hWnd],ID_SCRIPT_EDIT,WM_SETTEXT,NULL,szZeroString
   mov	   esi,szText1
   call    str_len
   push    eax
   pop	   ecx
   mov	   edi,szBuffer
   rep	   movsb
   mov	   esi,szModule
   call    str_len
   push    eax
   pop	   ecx
   rep	   movsb
   mov	   al,0Dh
   stosb
   mov	   al,0Ah
   stosb
   mov	   esi,szText2
   call    str_len
   mov	   ecx,eax
   rep	   movsb
   mov	   al,0Dh
   stosb
   mov	   al,0Ah
   stosb
   mov	   [dwBufferPointer],edi

   invoke  GetDlgItem,[hWnd],ID_SCRIPT_EDIT
   call    [HzorDoJob]
   test    eax,eax
   jnz	   @f
   invoke  SendDlgItemMessage,[hWnd],ID_SCRIPT_EDIT,WM_SETTEXT,NULL,szZeroString
   invoke  MessageBox,NULL,szModuleCantWork,szErrorCap,MB_OK or MB_ICONHAND
   jmp	   processed
@@:
   invoke  SendDlgItemMessage,[hWnd],ID_SCRIPT_EDIT,WM_GETTEXTLENGTH,NULL,NULL
   push    eax
   test    eax,eax
   jz	   @f
   inc	   eax
   invoke  SendDlgItemMessage,[hWnd],ID_SCRIPT_EDIT,WM_GETTEXT,eax,[dwBufferPointer]
@@:
   pop	   eax
   mov	   edi,[dwBufferPointer]
   add	   edi,eax

   mov	   esi,szText3
   call    str_len
   mov	   ecx,eax
   repnz   movsb
   mov	   al,0
   stosb
   mov	   [dwBufferPointer],edi
   mov	   esi,szBuffer
   call    str_len

   invoke  SendDlgItemMessage,[hWnd],ID_SCRIPT_EDIT,WM_SETTEXT,eax,szBuffer

   call    UnLoadDll
   jmp	   processed

idpatchpe:
   call    DoMainJob
   inc	   eax
   jnz	   processed
   mov	   esi,szFileName
   mov	   edi,szBakFileName
   call    str_len
   mov	   ecx,eax
   rep	   movsb
   mov	   eax,'.bak'
   stosd
   mov	  al,0
   stosb
   invoke CopyFile,szFileName,szBakFileName,TRUE
   invoke CreateFile,szFileName,GENERIC_WRITE,FILE_SHARE_READ,0,OPEN_EXISTING,FILE_ATTRIBUTE_ARCHIVE or FILE_ATTRIBUTE_HIDDEN or FILE_ATTRIBUTE_READONLY or FILE_ATTRIBUTE_SYSTEM,0
   mov	  [dwFile],eax
   cmp	  eax,-1
   jnz	  @f
   invoke MessageBox,NULL,szFileOpenError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  processed
@@:
   mov	   [dwFile],eax

   mov	   ecx,[dwPatchPointer]
   mov	   esi,szPatchBuffer
   mov	   [dwPatchPointer],esi
   push    ecx
@@:
   pop	   ecx
   push    ecx
   cmp	   esi,ecx
   jge	   .patch_end
   push    dword [esi]
   pop	   dword [dwPatchAddr]
   add	   esi,4
   push    dword [esi]
   pop	   [dwPatchCount]
   add	   esi,4
   invoke  SetFilePointer,[dwFile],[dwPatchAddr],0,0
   invoke  WriteFile,[dwFile],esi,[dwPatchCount],dwReadWrite,0
   add	   esi,[dwPatchCount]
   jmp	   @b
.patch_end:

   pop	   ecx
   cmp	   [dwRAW_OUT],0
   jz	   .skeep_patching_jump_to_inline
   invoke  SetFilePointer,[dwFile],[dwRAW_OUT],0,0
   invoke  WriteFile,[dwFile],szJumpToInlineBuffer,[dwStolenBytesCount],dwReadWrite,0

.skeep_patching_jump_to_inline:
   cmp	   [dwFreeSpaceRAW],0
   jz	   @f
   mov	   eax,[dwFreeSpaceRAW]
   jmp	   .patching_free_space_defined
@@:
   mov	   eax,[dwInlinePointer]
   sub	   eax,szInlineBuffer
   add	   eax,6
   call    seek_free_space
   test    eax,eax
   jnz	   @f
   pop	   ecx
   pop	   edi
   pop	   esi
   invoke  MessageBox,NULL,szCantFindFreeSpace,szErrorCap,MB_OK
   jmp	   done_parse

@@:
.patching_free_space_defined:
   invoke  SetFilePointer,[dwFile],eax,0,0
   mov	   eax,[dwInlinePointer]
   sub	   eax,szInlineBuffer
   invoke  WriteFile,[dwFile],szInlineBuffer,eax,dwReadWrite,0
   invoke  CloseHandle,[dwFile]
   invoke  MessageBox,NULL,szPatched,szDoneCap,MB_OK
   jmp	   processed

idgencode:
   call    DoMainJob
   inc	   eax
   jnz	   processed

   mov	   [dwStringPointer],szStringResultBuffer

   mov	   ecx,[dwPatchPointer]
   mov	   esi,szPatchBuffer
   mov	   [dwPatchPointer],esi

.parse_next_patch:
   cmp	   esi,ecx
   jge	   .patch_end
   push    dword [esi]
   pop	   dword [dwPatchAddr]
   add	   esi,4
   push    dword [esi]
   pop	   [dwPatchCount]
   add	   esi,4

   push    ecx
   push    esi

   inc	   [dwPatchNum]
   mov	   eax,[dwPatchNum]
   mov	   edi,szPatchNumBuffer
   call    dword2hex
   mov	   edi,[dwStringPointer]
   mov	   esi,szAddr
   mov	   ecx,5 ;"addr_"
   rep	   movsb
   mov	   esi,szPatchNumBuffer
   call    str_len
   mov	   ecx,eax
   rep	   movsb
   mov	   esi,szDd
   mov	   ecx,4 ;" dd "
   rep	   movsb

   mov	   eax,[dwPatchAddr]
   push    edi
   mov	   edi,szPatchAddrRAW
   call    dword2hex
   pop	   edi

   mov	   esi,szPatchAddrRAW
   call    str_len
   mov	   ecx,eax
   cmp	   byte [esi],40h
   jl	   @f
   mov	   al,'0'
   stosb
@@:
   rep	   movsb

   mov	   al,'h'
   stosb

   mov	   al,0Dh
   stosb
   mov	   al,0Ah
   stosb

   mov	   esi,szData
   mov	   ecx,5 ;"data_"
   rep	   movsb
   mov	   esi,szPatchNumBuffer
   call    str_len
   mov	   ecx,eax
   rep	   movsb
   mov	   esi,szDb
   mov	   ecx,4 ;" db "
   rep	   movsb



   pop	   esi

   mov	   ecx,[dwPatchCount]
   inc	   ecx

.write_next_byte:
   dec	   ecx
   jz	   .this_patch_end
   xor	   eax,eax
   lodsb
   push    edi
   mov	   edi,szPatchByte
   call    dword2hex
   cmp	   byte [edi],40h
   jl	   @f
   pop	   edi
   mov	   al,'0'
   stosb
   push    edi
@@:
   pop	   edi
   push    esi
   mov	   esi,szPatchByte
   call    str_len
   push    ecx
   mov	   ecx,eax
   rep	   movsb
   pop	   ecx
   pop	   esi
   mov	   al,'h'
   stosb

   cmp	   ecx,1
   jz	   @f
   mov	   al,','
   stosb
@@:
   jmp	   .write_next_byte
.this_patch_end:

   mov	   al,0Dh
   stosb
   mov	   al,0Ah
   stosb

   push    esi
   mov	   esi,szDataSize
   mov	   ecx,10 ;"data_size_"
   rep	   movsb
   mov	   esi,szPatchNumBuffer
   call    str_len
   mov	   ecx,eax
   rep	   movsb
   mov	   esi,szDd
   mov	   ecx,4 ;" dd "
   rep	   movsb
   mov	   al,'$'
   stosb
   mov	   al,'-'
   stosb
   mov	   esi,szData
   mov	   ecx,5 ;"data_"
   rep	   movsb
   mov	   esi,szPatchNumBuffer
   call    str_len
   mov	   ecx,eax
   rep	   movsb
   pop	   esi

   mov	   al,0Dh
   stosb
   mov	   al,0Ah
   stosb

   pop	   ecx
   mov	   [dwStringPointer],edi
   jmp	   .parse_next_patch
.patch_end:

   cmp	   [dwRAW_OUT],0
   jz	   skeep_write_jump_to_inline
   mov	   edi,szRAW_OUT
   mov	   eax,[dwRAW_OUT]
   call    dword2hex

   inc	   [dwPatchNum]
   mov	   eax,[dwPatchNum]
   mov	   edi,szPatchNumBuffer
   call    dword2hex
   mov	   edi,[dwStringPointer]
   mov	   esi,szAddr
   mov	   ecx,5 ;"addr_"
   rep	   movsb
   mov	   esi,szPatchNumBuffer
   call    str_len
   mov	   ecx,eax
   rep	   movsb
   mov	   esi,szDd
   mov	   ecx,4 ;" dd "
   rep	   movsb

   mov	   esi,szRAW_OUT
   call    str_len
   mov	   ecx,eax
   cmp	   byte [esi],40h
   jl	   @f
   mov	   al,'0'
   stosb
@@:
   rep	   movsb

   mov	   al,'h'
   stosb

   mov	   al,0Dh
   stosb
   mov	   al,0Ah
   stosb

   mov	   esi,szData
   mov	   ecx,5 ;"data_"
   rep	   movsb
   mov	   esi,szPatchNumBuffer
   call    str_len
   mov	   ecx,eax
   rep	   movsb
   mov	   esi,szDb
   mov	   ecx,4 ;" db "
   rep	   movsb


   mov	   esi,szJumpToInlineBuffer
   mov	   ecx,[dwStolenBytesCount]
   inc	   ecx

   dec	   esi

.parse_next_jumptoinline:
   inc	   esi
   dec	   ecx
   jz	   .jumptoinline_end

   push    esi
   push    ecx

   xor	   eax,eax
   mov	   al,byte [esi]
   cmp	   al,0A0h
   jb	   @f
   push    eax
   mov	   al,'0'
   stosb
   pop	   eax
@@:
   push    edi
   mov	   edi,szInlineByte
   call    dword2hex
   pop	   edi
   mov	   esi,szInlineByte
   call    str_len
   mov	   ecx,eax
   rep	   movsb

   mov	   al,'h'
   stosb

   pop	   ecx
   pop	   esi

   cmp	   ecx,1
   jz	   @f
   mov	   al,','
   stosb
@@:
   jmp	   .parse_next_jumptoinline
.jumptoinline_end:

   mov	   al,0Dh
   stosb
   mov	   al,0Ah
   stosb

   push    esi
   mov	   esi,szDataSize
   mov	   ecx,10 ;"data_size_"
   rep	   movsb
   mov	   esi,szPatchNumBuffer
   call    str_len
   mov	   ecx,eax
   rep	   movsb
   mov	   esi,szDd
   mov	   ecx,4 ;" dd "
   rep	   movsb
   mov	   al,'$'
   stosb
   mov	   al,'-'
   stosb
   mov	   esi,szData
   mov	   ecx,5 ;"data_"
   rep	   movsb
   mov	   esi,szPatchNumBuffer
   call    str_len
   mov	   ecx,eax
   rep	   movsb
   pop	   esi

   mov	   al,0Dh
   stosb
   mov	   al,0Ah
   stosb

   mov	   [dwStringPointer],edi



skeep_write_jump_to_inline:
   cmp	   [dwFreeSpaceRAW],0
   jz	   @f
   mov	   eax,[dwFreeSpaceRAW]
   jmp	   free_space_defined
@@:
   cmp	   [dwMaxSize],0
   jz	   @f
   pop	   ecx
   pop	   edi
   pop	   esi
   invoke  MessageBox,NULL,szDontDefineMax,szErrorCap,MB_OK
   jmp	   done_parse
@@:
   mov	   eax,[dwInlinePointer]
   sub	   eax,szInlineBuffer
   add	   eax,6
   mov	   ebx,eax
   call    seek_free_space
   test    eax,eax
   jnz	   @f
   pop	   ecx
   pop	   edi
   pop	   esi
   invoke  MessageBox,NULL,szCantFindFreeSpace,szErrorCap,MB_OK
   jmp	   done_parse

@@:
free_space_defined:
   cmp	   [dwMaxSize],0
   jz	   @f
   cmp	   [dwMaxSize],ebx
   jae	   @f
   pop	   ecx
   pop	   edi
   pop	   esi
   invoke  MessageBox,NULL,szVeryBig,szErrorCap,MB_OK
   jmp	   done_parse
@@:
   mov	   edi,szPatchAddrRAW
   mov	   [dwFreeSpaceRAW],eax
   call    dword2hex

   inc	   [dwPatchNum]
   mov	   eax,[dwPatchNum]
   mov	   edi,szPatchNumBuffer
   call    dword2hex
   mov	   edi,[dwStringPointer]
   mov	   esi,szAddr
   mov	   ecx,5 ;"addr_"
   rep	   movsb
   mov	   esi,szPatchNumBuffer
   call    str_len
   mov	   ecx,eax
   rep	   movsb
   mov	   esi,szDd
   mov	   ecx,4 ;" dd "
   rep	   movsb

   mov	   esi,szPatchAddrRAW
   call    str_len
   mov	   ecx,eax
   cmp	   byte [esi],40h
   jl	   @f
   mov	   al,'0'
   stosb
@@:
   rep	   movsb

   mov	   al,'h'
   stosb

   mov	   al,0Dh
   stosb
   mov	   al,0Ah
   stosb

   mov	   esi,szData
   mov	   ecx,5 ;"data_"
   rep	   movsb
   mov	   esi,szPatchNumBuffer
   call    str_len
   mov	   ecx,eax
   rep	   movsb
   mov	   esi,szDb
   mov	   ecx,4 ;" db "
   rep	   movsb


   mov	   ecx,[dwInlinePointer]
   mov	   esi,szInlineBuffer
   sub	   ecx,esi
   mov	   [dwInlinePointer],esi
   inc	   ecx
   dec	   esi

.parse_next_inline:
   inc	   esi
   dec	   ecx
   jz	   .inline_end

   push    esi
   push    ecx

   xor	   eax,eax
   mov	   al,byte [esi]
   cmp	   al,0A0h
   jb	   @f
   push    eax
   mov	   al,'0'
   stosb
   pop	   eax
@@:
   push    edi
   mov	   edi,szInlineByte
   call    dword2hex
   pop	   edi
   mov	   esi,szInlineByte
   call    str_len
   mov	   ecx,eax
   rep	   movsb

   mov	   al,'h'
   stosb

   pop	   ecx
   pop	   esi

   cmp	   ecx,1
   jz	   @f
   mov	   al,','
   stosb
@@:
   jmp	   .parse_next_inline
.inline_end:

   mov	   al,0Dh
   stosb
   mov	   al,0Ah
   stosb

   push    esi
   mov	   esi,szDataSize
   mov	   ecx,10 ;"data_size_"
   rep	   movsb
   mov	   esi,szPatchNumBuffer
   call    str_len
   mov	   ecx,eax
   rep	   movsb
   mov	   esi,szDd
   mov	   ecx,4 ;" dd "
   rep	   movsb
   mov	   al,'$'
   stosb
   mov	   al,'-'
   stosb
   mov	   esi,szData
   mov	   ecx,5 ;"data_"
   rep	   movsb
   mov	   esi,szPatchNumBuffer
   call    str_len
   mov	   ecx,eax
   rep	   movsb
   pop	   esi

   mov	   al,0Dh
   stosb
   mov	   al,0Ah
   stosb

   mov	   [dwStringPointer],edi

   invoke  GetSaveFileName,ofn_struct2
   mov	   esi,szFileName2
   call    str_len
   test    eax,eax
   jz	   .canceled
   invoke  SetFileAttributes,szFileName2,0080h
   invoke  CreateFile,szFileName2,GENERIC_WRITE,FILE_SHARE_WRITE,0,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0
   cmp	   eax,-1
   jnz	   @f
   pop	   ecx
   pop	   edi
   pop	   esi
   invoke  MessageBox,NULL,szFileSaveError,szErrorCap,MB_OK
   jmp	   done_parse
@@:
   mov	   [dwFile2],eax
   invoke  SetFilePointer,eax,0,0,0

   mov	   esi,szStringResultBuffer
   call    str_len
   test    eax,eax
   jz	   @f
   invoke  WriteFile,[dwFile2],szStringResultBuffer,eax,dwReadWrite,0
@@:
   invoke  CloseHandle,[dwFile2]
   invoke  MessageBox,NULL,szCodeGenerated,szDoneCap,MB_OK
.canceled:
   pop	   ecx
   pop	   edi
   pop	   esi

processed:
   mov	   eax,1

finish:
   pop	   edi esi ebx
   ret
endp

proc LoadDll
   mov	   ecx,8
   mov	   esi,szPluginsDir
   mov	   edi,szModule
   repnz   movsb
   invoke  GetDlgItemText,eax,ID_MODULE,edi,0xFF
   invoke  LoadLibrary,szModule
   test    eax,eax
   jz	   CantLoadLibrary
   mov	   [hModule],eax
   invoke  GetProcAddress,[hModule],szHzorInit
   test    eax,eax
   jz	   CantFindProc
   mov	   [HzorInit],eax
   invoke  GetProcAddress,[hModule],szHzorDoJob
   test    eax,eax
   jz	   CantFindProc
   mov	   [HzorDoJob],eax
   invoke  GetProcAddress,[hModule],szHzorPluginInfo
   test    eax,eax
   jz	   CantFindProc
   mov	   [HzorPluginInfo],eax
   invoke  GetProcAddress,[hModule],szHzorIdentify
   test    eax,eax
   jz	   CantFindProc
   mov	   [HzorIdentify],eax
   or	   eax,-1
   jmp	   @f
CantLoadLibrary:
   invoke  MessageBox,NULL,szCantLoadLibrary,szErrorCap,MB_OK or MB_ICONHAND
   xor	   eax,eax
   jmp	   @f
CantFindProc:
   invoke  MessageBox,NULL,szCantFindProc,szErrorCap,MB_OK or MB_ICONHAND
   xor	   eax,eax
   jmp	   @f
@@:
   retn
endp

proc UnLoadDll
   cmp	   [hModule],0
   jz	   @f
   pushad
   invoke  FreeLibrary,[hModule]
   popad
   @@:
   ret
endp

; =========================================================================================
; (C) arnix [arnix@freenet.am]
; Gets the dword value in EAX register and an address to a buffer to write the string in EDI (need max. 9 byte-length)
; Returns nothing, but the result is the zero-terminated string in address of EDI
proc dword2hex
   push    eax
   push    ecx
   push    edi

   push    10h
   pop	   ecx
   push    -30h
@@:
   xor	   edx,edx
   div	   ecx
   push    edx
   test    eax,eax
   jnz	   @b
.next:
   pop	   eax
   add	   al,30h
   cmp	   al,3Ah
   jb	   @f
   add	   al,07h
@@:
   stosb
   test    al,al
   jnz	   .next

   pop	   edi
   pop	   ecx
   pop	   eax
ret
endp

; =========================================================================================
; Gets the address of max.8-bytes zero-terminated string with hex string in EAX register
; Returns the dword value in EAX register
; (C) arnix [arnix@freenet.am]
proc hex2dword
   push    ebx

   mov	   ebx,eax
   xor	   eax,eax
.next_byte:
   cmp	   byte [ebx],0
   jz	   .exit
   shl	   eax,4
   sub	   byte [ebx],30h
;Check if the byte is '0'-'9' or 'A'-'F', if no, return 0
   cmp	   byte [ebx],16h
   jg	   .invalid_char
   cmp	   byte [ebx],00h
   jl	   .invalid_char
   cmp	   byte [ebx],09h
   jg	   .and
   jmp	   @f
.and:
   cmp	   byte [ebx],11h
   jl	   .invalid_char
   jmp	   @f
;Check complete
.invalid_char:
   or	   eax,-1
   jmp	   .exit
@@:
   cmp	   byte [ebx],0Ah
   jl	   @f
   sub	   byte [ebx],07h
@@:
   add	   al,byte [ebx]
   inc	   ebx
   jmp	   .next_byte
.exit:
   pop	   ebx
ret
endp

; =========================================================================================
; (C) arnix [arnix@freenet.am]
; Gets the address of zero terminated string in ESI register
; Returns the length in EAX register
proc str_len
   push    esi
   push    ecx

   or	   ecx,-1
@@:
   inc	   ecx
   lodsb
   test    al,al
   jnz	   @b

   push    ecx
   pop	   eax
   pop	   ecx
   pop	   esi
retn
endp

; =========================================================================================
; (C) arnix [arnix@freenet.am]
proc va2raw
   push   ecx
   push   esi
   push   edi

   xor	  ecx,ecx
   mov	  cx,[dwSectNumber]
   mov	  edi,[dwSectionsAddr]
   sub	  eax,[dwImageBase]
.next_section:
   push   eax
   push   dword [edi+08h]
   pop	  [dwVSize]
   push   dword [edi+0Ch]
   pop	  [dwVOffset]
   push   dword [edi+14h]
   pop	  eax
   xor	  edx,edx
   div	  [dwFileAlignment]
   mul	  [dwFileAlignment]
   mov	  [dwROffset],eax
   pop	  eax

   cmp	  eax,[dwVOffset]
   jna	  @f
   mov	  esi,[dwVSize]
   add	  esi,[dwVOffset]
   cmp	  eax,esi
   ja	  @f
   mov	  esi,[dwROffset]
   add	  esi,eax
   mov	  eax,esi
   sub	  eax,[dwVOffset]
   jmp	  .exit
@@:
   add	  edi,28h
   dec	  ecx
   jnz	  .next_section
;cant calculate, try to guess ;)

.exit:
   pop	  edi
   pop	  esi
   pop	  ecx
retn
endp

; =========================================================================================
; (C) arnix [arnix@freenet.am]
; Gets the RAW address in the PE file in EAX register
; Returns VirtualAddress in EAX register
proc raw2va
   push   ecx
   push   esi
   push   edi

   xor	  ecx,ecx
   mov	  cx,[dwSectNumber]
   mov	  edi,[dwSectionsAddr]
.next_section:
   push   eax
   push   dword [edi+0Ch]
   pop	  [dwVOffset]

   push   dword [edi+10h]
   pop	  eax
   xor	  edx,edx
   div	  [dwFileAlignment]
   mul	  [dwFileAlignment]
   add	  eax,[dwFileAlignment]
   mov	  [dwRSize],eax

   push   dword [edi+14h]
   pop	  eax
   xor	  edx,edx
   div	  [dwFileAlignment]
   mul	  [dwFileAlignment]
   mov	  [dwROffset],eax
   pop	  eax


   cmp	  eax,[dwROffset]
   jna	  @f
   mov	  esi,[dwRSize]
   add	  esi,[dwROffset]
   cmp	  eax,esi
   ja	  @f
   mov	  esi,[dwVOffset]
   add	  esi,eax
   mov	  eax,esi
   add	  eax,[dwImageBase]
   sub	  eax,[dwROffset]
   jmp	  .exit
@@:
   add	  edi,28h
   dec	  ecx
   jnz	  .next_section
;cant calculate, try to guess ;)
   add	  eax,[dwImageBase]
.exit:
   pop	  edi
   pop	  esi
   pop	  ecx
retn
endp

proc LoadFile
   push   ecx

   invoke SetFileAttributes,szFileName,0080h
   invoke CreateFile,szFileName,80000000h,0,0,3,0080h,0
   mov	  [dwFile],eax
   cmp	  eax,-1
   jnz	  @f
   invoke MessageBox,NULL,szFileOpenError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  .exit
@@:
   invoke GetFileSize,[dwFile],0
   mov	  [dwFileSize],eax
   invoke GlobalAlloc,0000h,[dwFileSize]
   mov	  [dwMemptr],eax
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szAllocError,szErrorCap,MB_OK
   invoke CloseHandle,[dwFile]
   xor	  eax,eax
   jmp	  .exit
@@:
   invoke ReadFile,[dwFile],[dwMemptr],[dwFileSize],dwReadWrite,0
   mov	  edi,[dwMemptr]
   mov	  esi,edi
   add	  esi,[dwFileSize]
   mov	  ax,word [edi]
   cmp	  ax,[wMZ]
   jz	  @f
   invoke MessageBox,NULL,szInvalidPEError,szErrorCap,MB_OK
   invoke CloseHandle,[dwFile]
   xor	  eax,eax
   jmp	  .exit
@@:
   add	  edi,3Ch
   mov	  eax,[edi]
   mov	  edi,[dwMemptr]
   add	  edi,eax
   mov	  eax,[edi]
   cmp	  eax,[dwPE]
   jz	  @f
   invoke MessageBox,NULL,szInvalidPEError,szErrorCap,MB_OK
   invoke CloseHandle,[dwFile]
   xor	  eax,eax
   jmp	  .exit
@@:
   push   edi
   add	  edi,06h
   mov	  ax,word [edi]
   mov	  [dwSectNumber],ax
   add	  edi,2Eh
   push   dword [edi]
   pop	  [dwImageBase]
   pop	  edi
   push   edi
   add	  edi,03Ch
   push   dword [edi]
   pop	  [dwFileAlignment]
   pop	  edi
   mov	  eax,edi
   add	  eax,14h
   movzx  eax,word [eax]
   add	  eax,18h ;Size of PE Header
   mov	  [dwSectionsAddr],edi
   add	  [dwSectionsAddr],eax
.exit:
   pop	  ecx
ret
endp

proc seek_free_space
   push   ebx
   push   ecx
   push   esi
   push   edi

   xor	  ecx,ecx
   mov	  cx,[dwSectNumber]
   mov	  edi,[dwSectionsAddr]
   mov	  esi,28h
   dec	  ecx
   imul   esi,ecx
   inc	  ecx
   add	  edi,esi
next_section:
   push   dword [edi+10h]
   pop	  [dwRSize]
   cmp	  [dwRSize],0
   jnz	  @f
   dec	  ecx
   sub	  edi,28h
   jmp	  next_section
@@:
   push   dword [edi+14h]
   pop	  [dwROffset]
   mov	  esi,[dwROffset]
   add	  esi,[dwMemptr]
   mov	  [dwSecAddrPlusMem],esi
   add	  esi,[dwRSize]
   xor	  ebx,ebx
;   sub    esi,[dwRSize]
   inc	  esi
next_0:
   dec	  esi
   cmp	  esi,[dwSecAddrPlusMem]
   jz	  @f
   cmp	  byte [esi],0
   jnz	  @f
   inc	  ebx
   jmp	  next_0
@@:
   cmp	  eax,ebx
   jnl	  @f
.done:
   sub	  esi,[dwMemptr]
   add	  esi,ebx
   sub	  esi,eax
   mov	  eax,esi
   jmp	  .exit
@@:
   cmp	  esi,[dwSecAddrPlusMem]
   jz	  @f
   xor	  ebx,ebx
   jmp	  next_0
@@:
   sub	  edi,28h
   dec	  ecx
   jnz	  next_section
;cant calculate
   xor	  eax,eax
.exit:
   pop	  edi
   pop	  esi
   pop	  ecx
   pop	  ebx
ret
endp